/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.IValTextField;
import com.jstatcom.model.JSCConstants;

public class VarNameSelector
extends IValTextField {
    private String varName = null;

    public VarNameSelector() {
        this.setSize(48, this.getHeight());
        this.setVarName("varname");
    }

    public String getVarName() {
        return this.varName;
    }

    @Override
    public void handleError(String msg) {
        super.handleError(msg + "\nThe input is set back to the previous value.");
        this.setVarName(this.varName);
    }

    public void setVarName(String newVarName) {
        String error = JSCConstants.isValidName(newVarName);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        this.varName = newVarName.trim().toLowerCase();
        this.setText(this.varName);
    }

    @Override
    public String validateInput() {
        String input = this.getText().trim().toLowerCase();
        String error = JSCConstants.isValidName(input);
        if (error == null) {
            this.varName = input;
        }
        return error;
    }
}

