/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.parametrics.onesample;

import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class NormalOneSample {
    public static boolean testMean(double xbar, int n, double H0mean, double std, boolean is_twoTailed, double aLevel) {
        if (n <= 0 || std <= 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double z = (xbar - H0mean) / (std / Math.sqrt(n));
        boolean rejectH0 = NormalOneSample.checkCriticalValue(z, is_twoTailed, aLevel);
        return rejectH0;
    }

    public static boolean testSum(double xsum, int n, double H0mean, double std, boolean is_twoTailed, double aLevel) {
        if (n <= 0 || std <= 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double z = (xsum - (double)n * H0mean) / (std * Math.sqrt(n));
        boolean rejectH0 = NormalOneSample.checkCriticalValue(z, is_twoTailed, aLevel);
        return rejectH0;
    }

    public static boolean testPercentage(double pbar, int n, double H0p, boolean is_twoTailed, double aLevel) {
        if (n <= 0 || H0p <= 0.0 || pbar < 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double z = (pbar - H0p) / Math.sqrt(H0p * (1.0 - H0p) / (double)n);
        boolean rejectH0 = NormalOneSample.checkCriticalValue(z, is_twoTailed, aLevel);
        return rejectH0;
    }

    private static boolean checkCriticalValue(double score, boolean is_twoTailed, double aLevel) {
        double probability = ContinuousDistributions.gaussCdf(score);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (probability <= a || probability >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }
}

