/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.relatedsamples;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.descriptivestatistics.Ranks;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class SpearmanCorrelation {
    public static double calculateCorrelation(TransposeDataList transposeDataList) {
        Object[] keys = transposeDataList.keySet().toArray();
        if (keys.length != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        Object keyX = keys[0];
        Object keyY = keys[1];
        FlatDataList flatDataListX = transposeDataList.get(keyX).copy();
        FlatDataList flatDataListY = transposeDataList.get(keyY).copy();
        int n = flatDataListX.size();
        if (n <= 0 || n != flatDataListY.size()) {
            throw new IllegalArgumentException("The number of observations in each group must be equal and larger than 0.");
        }
        AssociativeArray tiesCounter = Ranks.getRanksFromValues(flatDataListX);
        double Sum_Rx_square = ((double)(n * n) - 1.0) * (double)n;
        for (Object value : tiesCounter.values()) {
            double Ti = TypeInference.toDouble(value);
            Sum_Rx_square -= (Ti * Ti - 1.0) * Ti;
        }
        Sum_Rx_square /= 12.0;
        tiesCounter = Ranks.getRanksFromValues(flatDataListY);
        double Sum_Ry_square = ((double)(n * n) - 1.0) * (double)n;
        for (Object value : tiesCounter.values()) {
            double Ti = TypeInference.toDouble(value);
            Sum_Ry_square -= (Ti * Ti - 1.0) * Ti;
        }
        Sum_Ry_square /= 12.0;
        double Sum_Di_square = 0.0;
        for (int j = 0; j < n; ++j) {
            double di = flatDataListX.getDouble(j) - flatDataListY.getDouble(j);
            Sum_Di_square += di * di;
        }
        double Rs = (Sum_Rx_square + Sum_Ry_square - Sum_Di_square) / (2.0 * Math.sqrt(Sum_Rx_square * Sum_Ry_square));
        return Rs;
    }

    public static boolean test(TransposeDataList transposeDataList, boolean is_twoTailed, double aLevel) {
        if (transposeDataList.isEmpty()) {
            return false;
        }
        double SpearmanCorrelation2 = SpearmanCorrelation.calculateCorrelation(transposeDataList);
        Object firstKey = transposeDataList.keySet().iterator().next();
        int n = transposeDataList.get(firstKey).size();
        double pvalue = SpearmanCorrelation.scoreToPvalue(SpearmanCorrelation2, n);
        boolean rejectH0 = false;
        double a = aLevel;
        if (is_twoTailed) {
            a = aLevel / 2.0;
        }
        if (pvalue <= a || pvalue >= 1.0 - a) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n) {
        double Zs = score * Math.sqrt((double)n - 1.0);
        double Ts = score * Math.sqrt(((double)n - Zs) / (1.0 - score * score));
        return ContinuousDistributions.studentsCdf(Ts, n - 2);
    }
}

