/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.relatedsamples;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.descriptivestatistics.Ranks;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Friedman {
    public static double getPvalue(DataTable2D dataTable) {
        if (!dataTable.isValid()) {
            throw new IllegalArgumentException("The provided Table does not have a rectangular format.");
        }
        HashMap columnSum = new HashMap();
        ArrayList<Integer> tiesCounter = new ArrayList<Integer>();
        for (Map.Entry<Object, AssociativeArray> entry1 : dataTable.entrySet()) {
            AssociativeArray row = entry1.getValue();
            AssociativeArray tiedValuesArray = Ranks.getRanksFromValues(row.copy());
            for (Object object : tiedValuesArray.values()) {
                tiesCounter.add(((Number)object).intValue());
            }
            for (Map.Entry entry : row.entrySet()) {
                Object j = entry.getKey();
                double v = TypeInference.toDouble(entry.getValue());
                if (!columnSum.containsKey(j)) {
                    columnSum.put(j, v);
                    continue;
                }
                columnSum.put(j, (Double)columnSum.get(j) + v);
            }
        }
        int n = dataTable.size();
        int k = columnSum.size();
        double Fscore = 0.0;
        for (Double d : columnSum.values()) {
            Fscore += d * d;
        }
        Fscore = 12.0 / ((double)(n * k) * ((double)k + 1.0)) * Fscore - 3.0 * (double)n * ((double)k + 1.0);
        if (!tiesCounter.isEmpty()) {
            double C = 0.0;
            for (Integer Ti : tiesCounter) {
                C += ((double)(Ti * Ti) - 1.0) * (double)Ti.intValue();
            }
            Fscore /= 1.0 - C / ((double)(n * k) * ((double)(k * k) - 1.0));
        }
        double pvalue = Friedman.scoreToPvalue(Fscore, k);
        return pvalue;
    }

    public static boolean test(DataTable2D dataTable, double aLevel) {
        double pvalue = Friedman.getPvalue(dataTable);
        boolean rejectH0 = false;
        if (pvalue <= aLevel) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int k) {
        return 1.0 - ContinuousDistributions.chisquareCdf(score, k - 1);
    }
}

