/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.nonparametrics.relatedsamples;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.DataTable2D;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import java.util.HashMap;
import java.util.Map;

public class CochranQ {
    public static double getPvalue(DataTable2D dataTable) {
        if (!dataTable.isValid()) {
            throw new IllegalArgumentException("The provided Table does not have a rectangular format.");
        }
        HashMap XdotJ = new HashMap();
        HashMap<Object, Double> XIdot = new HashMap<Object, Double>();
        double Xdotdot = 0.0;
        for (Map.Entry<Object, AssociativeArray> entry1 : dataTable.entrySet()) {
            Object i = entry1.getKey();
            AssociativeArray row = entry1.getValue();
            for (Map.Entry entry : row.entrySet()) {
                Object j = entry.getKey();
                double v = TypeInference.toDouble(entry.getValue());
                if (!XdotJ.containsKey(j)) {
                    XdotJ.put(j, v);
                } else {
                    XdotJ.put(j, (Double)XdotJ.get(j) + v);
                }
                if (!XIdot.containsKey(i)) {
                    XIdot.put(i, v);
                } else {
                    XIdot.put(i, (Double)XIdot.get(i) + v);
                }
                Xdotdot += v;
            }
        }
        int k = XdotJ.size();
        int n = XIdot.size();
        double SumOfSquaredXdotJ = 0.0;
        for (Double d : XdotJ.values()) {
            SumOfSquaredXdotJ += d * d;
        }
        double SumOfSquaredXIdot = 0.0;
        double SumOfXIdot = 0.0;
        for (Double value : XIdot.values()) {
            SumOfSquaredXIdot += value * value;
            SumOfXIdot += value.doubleValue();
        }
        double Qscore = ((double)k - 1.0) * ((double)k * SumOfSquaredXdotJ - Xdotdot * Xdotdot) / ((double)k * SumOfXIdot - SumOfSquaredXIdot);
        double pvalue = CochranQ.scoreToPvalue(Qscore, n, k);
        return pvalue;
    }

    public static boolean test(DataTable2D dataTable, double aLevel) {
        double pvalue = CochranQ.getPvalue(dataTable);
        boolean rejectH0 = false;
        if (pvalue <= aLevel) {
            rejectH0 = true;
        }
        return rejectH0;
    }

    private static double scoreToPvalue(double score, int n, int k) {
        return 1.0 - ContinuousDistributions.chisquareCdf(score, k - 1);
    }
}

