/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.distributions;

import com.datumbox.framework.core.mathematics.discrete.Arithmetics;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;

public class DiscreteDistributions {
    public static double bernoulli(boolean k, double p) {
        if (p < 0.0) {
            throw new IllegalArgumentException("The probability p can't be negative.");
        }
        return k ? p : 1.0 - p;
    }

    public static double bernoulliCdf(int k, double p) {
        if (p < 0.0) {
            throw new IllegalArgumentException("The probability p can't be negative.");
        }
        double probabilitySum = 0.0;
        if (k >= 0) {
            probabilitySum = k < 1 ? 1.0 - p : 1.0;
        }
        return probabilitySum;
    }

    public static double binomial(int k, double p, int n) {
        if (k < 0 || p < 0.0 || n < 1) {
            throw new IllegalArgumentException("All the parameters must be positive and n larger than 1.");
        }
        k = Math.min(k, n);
        double probability = DiscreteDistributions.approxBinomialCdf(k, p, n);
        if (k > 0) {
            probability -= DiscreteDistributions.approxBinomialCdf(k - 1, p, n);
        }
        return probability;
    }

    public static double binomialCdf(int k, double p, int n) {
        if (k < 0 || p < 0.0 || n < 1) {
            throw new IllegalArgumentException("All the parameters must be positive and n larger than 1.");
        }
        k = Math.min(k, n);
        double probabilitySum = DiscreteDistributions.approxBinomialCdf(k, p, n);
        return probabilitySum;
    }

    private static double approxBinomialCdf(int k, double p, int n) {
        double Z = p;
        double A = k + 1;
        double B = n - k;
        double S = A + B;
        double BT = Math.exp(ContinuousDistributions.logGamma(S) - ContinuousDistributions.logGamma(B) - ContinuousDistributions.logGamma(A) + A * Math.log(Z) + B * Math.log(1.0 - Z));
        double probabilitySum = Z < (A + 1.0) / (S + 2.0) ? BT * ContinuousDistributions.betinc(Z, A, B) : 1.0 - BT * ContinuousDistributions.betinc(1.0 - Z, B, A);
        probabilitySum = 1.0 - probabilitySum;
        return probabilitySum;
    }

    public static double geometric(int k, double p) {
        if (k <= 0 || p < 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double probability = Math.pow(1.0 - p, k - 1) * p;
        return probability;
    }

    public static double geometricCdf(int k, double p) {
        if (k <= 0 || p < 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double probabilitySum = 0.0;
        for (int i = 1; i <= k; ++i) {
            probabilitySum += DiscreteDistributions.geometric(i, p);
        }
        return probabilitySum;
    }

    public static double negativeBinomial(int n, int r, double p) {
        if (n < 0 || r < 0 || p < 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        n = Math.max(n, r);
        double probability = Arithmetics.combination(n - 1, r - 1) * Math.pow(1.0 - p, n - r) * Math.pow(p, r);
        return probability;
    }

    public static double negativeBinomialCdf(int n, int r, double p) {
        if (n < 0 || r < 0 || p < 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        n = Math.max(n, r);
        double probabilitySum = 0.0;
        for (int i = 0; i <= r; ++i) {
            probabilitySum += DiscreteDistributions.negativeBinomial(n, i, p);
        }
        return probabilitySum;
    }

    public static double uniform(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The n must be larger than 1.");
        }
        double probability = 1.0 / (double)n;
        return probability;
    }

    public static double uniformCdf(int k, int n) {
        if (k < 0 || n < 1) {
            throw new IllegalArgumentException("All the parameters must be positive and n larger than 1.");
        }
        k = Math.min(k, n);
        double probabilitySum = (double)k * DiscreteDistributions.uniform(n);
        return probabilitySum;
    }

    public static double hypergeometric(int k, int n, int Kp, int Np) {
        if (k < 0 || n < 0 || Kp < 0 || Np < 0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        Kp = Math.max(k, Kp);
        Np = Math.max(n, Np);
        double probability = DiscreteDistributions.approxHypergeometricCdf(k, n, Kp, Np);
        if (k > 0) {
            probability -= DiscreteDistributions.approxHypergeometricCdf(k - 1, n, Kp, Np);
        }
        return probability;
    }

    public static double hypergeometricCdf(int k, int n, int Kp, int Np) {
        if (k < 0 || n < 0 || Kp < 0 || Np < 0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        Kp = Math.max(k, Kp);
        Np = Math.max(n, Np);
        double probabilitySum = DiscreteDistributions.approxHypergeometricCdf(k, n, Kp, Np);
        return probabilitySum;
    }

    private static double approxHypergeometricCdf(double x, double n, double m, double nn) {
        double Prob = 2.0 * m > nn ? (2.0 * n > nn ? DiscreteDistributions.hyp(nn - m - n + x, nn - n, nn - m, nn) : 1.0 - DiscreteDistributions.hyp(n - x - 1.0, n, nn - m, nn)) : (2.0 * n > nn ? 1.0 - DiscreteDistributions.hyp(m - x - 1.0, m, nn - n, nn) : DiscreteDistributions.hyp(x, n, m, nn));
        return Prob;
    }

    private static double hyp(double x, double n, double m, double nn) {
        double mz;
        double nz;
        if (m < n) {
            nz = m;
            mz = n;
        } else {
            nz = n;
            mz = m;
        }
        double h = 1.0;
        double s = 1.0;
        double k = 0.0;
        for (double i = 0.0; i < x; i += 1.0) {
            while (s > 1.0 && k < nz) {
                h *= 1.0 - mz / (nn - k);
                s *= 1.0 - mz / (nn - k);
                k += 1.0;
            }
            h = h * (nz - i) * (mz - i) / (i + 1.0) / (nn - nz - mz + i + 1.0);
            s += h;
        }
        while (k < nz) {
            s *= 1.0 - mz / (nn - k);
            k += 1.0;
        }
        return s;
    }

    public static double poisson(int k, double lamda) {
        if (k < 0 || lamda < 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double probability = DiscreteDistributions.poissonCdf(k, lamda);
        if (k > 0) {
            probability -= DiscreteDistributions.poissonCdf(k - 1, lamda);
        }
        return probability;
    }

    public static double poissonCdf(int k, double lamda) {
        if (k < 0 || lamda < 0.0) {
            throw new IllegalArgumentException("All the parameters must be positive.");
        }
        double probabilitySum = 1.0 - ContinuousDistributions.gammaCdf(lamda, k + 1);
        return probabilitySum;
    }
}

