/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.statistics.descriptivestatistics;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.FlatDataCollection;
import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TransposeDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class Descriptives {
    public static int count(Iterable it) {
        int n = 0;
        for (Object v : it) {
            if (v == null) continue;
            ++n;
        }
        return n;
    }

    public static double sum(FlatDataCollection flatDataCollection) {
        double sum = 0.0;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double value = it.next();
            if (value == null) continue;
            sum += value.doubleValue();
        }
        return sum;
    }

    public static double mean(FlatDataCollection flatDataCollection) {
        int n = 0;
        double mean = 0.0;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double value = it.next();
            if (value == null) continue;
            ++n;
            mean += value.doubleValue();
        }
        if (n == 0) {
            throw new IllegalArgumentException("No not null values where found in the collection.");
        }
        return mean /= (double)n;
    }

    public static double meanSE(FlatDataCollection flatDataCollection) {
        double std = Descriptives.std(flatDataCollection, true);
        double meanSE = std / Math.sqrt(Descriptives.count(flatDataCollection));
        return meanSE;
    }

    public static double median(FlatDataCollection flatDataCollection) {
        double[] doubleArray = flatDataCollection.stream().filter(x -> x != null).mapToDouble(TypeInference::toDouble).toArray();
        int n = doubleArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("The provided collection can't be empty.");
        }
        Arrays.sort(doubleArray);
        double median = n % 2 == 0 ? (doubleArray[n / 2 - 1] + doubleArray[n / 2]) / 2.0 : doubleArray[n / 2];
        return median;
    }

    public static double min(FlatDataCollection flatDataCollection) {
        double min = Double.POSITIVE_INFINITY;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double v = it.next();
            if (v == null || !(min > v)) continue;
            min = v;
        }
        return min;
    }

    public static double max(FlatDataCollection flatDataCollection) {
        double max = Double.NEGATIVE_INFINITY;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double v = it.next();
            if (v == null || !(max < v)) continue;
            max = v;
        }
        return max;
    }

    public static double minAbsolute(FlatDataCollection flatDataCollection) {
        double minAbs = Double.POSITIVE_INFINITY;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double v = it.next();
            if (v == null) continue;
            minAbs = Math.min(minAbs, Math.abs(v));
        }
        return minAbs;
    }

    public static double maxAbsolute(FlatDataCollection flatDataCollection) {
        double maxAbs = 0.0;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double v = it.next();
            if (v == null) continue;
            maxAbs = Math.max(maxAbs, Math.abs(v));
        }
        return maxAbs;
    }

    public static double range(FlatDataCollection flatDataCollection) {
        double range = Descriptives.max(flatDataCollection) - Descriptives.min(flatDataCollection);
        return range;
    }

    public static double geometricMean(FlatDataCollection flatDataCollection) {
        int n = 0;
        double geometricMean = 0.0;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double v = it.next();
            if (v == null) continue;
            if (v <= 0.0) {
                throw new IllegalArgumentException("Negative or zero values are not allowed.");
            }
            ++n;
            geometricMean += Math.log(v);
        }
        geometricMean = Math.exp(geometricMean / (double)n);
        return geometricMean;
    }

    public static double harmonicMean(FlatDataCollection flatDataCollection) {
        int n = 0;
        double harmonicMean = 0.0;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double v = it.next();
            if (v == null) continue;
            ++n;
            harmonicMean += 1.0 / v;
        }
        harmonicMean = (double)n / harmonicMean;
        return harmonicMean;
    }

    public static double variance(FlatDataCollection flatDataCollection, boolean isSample) {
        int n = 0;
        double mean = 0.0;
        double squaredMean = 0.0;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double v = it.next();
            if (v == null) continue;
            ++n;
            mean += v.doubleValue();
            squaredMean += v * v;
        }
        if (n <= 1) {
            throw new IllegalArgumentException("The provided collection must have more than 1 elements.");
        }
        double variance = (squaredMean /= (double)n) - (mean /= (double)n) * mean;
        if (isSample) {
            variance *= (double)n / ((double)n - 1.0);
        }
        return variance;
    }

    public static double std(FlatDataCollection flatDataCollection, boolean isSample) {
        double variance = Descriptives.variance(flatDataCollection, isSample);
        double std = Math.sqrt(variance);
        return std;
    }

    public static double cv(double std, double mean) {
        if (mean == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double cv = std / mean;
        return cv;
    }

    public static double moment(FlatDataCollection flatDataCollection, int r) {
        double mean = Descriptives.mean(flatDataCollection);
        return Descriptives.moment(flatDataCollection, r, mean);
    }

    public static double moment(FlatDataCollection flatDataCollection, int r, double mean) {
        int n = 0;
        double moment = 0.0;
        Iterator<Double> it = flatDataCollection.iteratorDouble();
        while (it.hasNext()) {
            Double v = it.next();
            if (v == null) continue;
            ++n;
            moment += Math.pow(v - mean, r);
        }
        if (n <= 1) {
            throw new IllegalArgumentException("The provided collection must have more than 1 elements.");
        }
        return moment /= (double)n;
    }

    public static double kurtosis(FlatDataCollection flatDataCollection) {
        int n = Descriptives.count(flatDataCollection);
        if (n <= 3) {
            throw new IllegalArgumentException("The provided collection must have more than 3 elements.");
        }
        double mean = Descriptives.mean(flatDataCollection);
        double m4 = Descriptives.moment(flatDataCollection, 4, mean);
        double m2 = Descriptives.moment(flatDataCollection, 2, mean);
        double s = (double)n / ((double)n - 1.0) * m2;
        double Mcapital4 = (double)n * m4;
        double Mcapital2 = (double)n * m2;
        double kurtosis = ((double)n * ((double)n + 1.0) * Mcapital4 - 3.0 * Mcapital2 * Mcapital2 * ((double)n - 1.0)) / (((double)n - 1.0) * ((double)n - 2.0) * ((double)n - 3.0) * s * s);
        return kurtosis;
    }

    public static double kurtosisSE(FlatDataCollection flatDataCollection) {
        int n = Descriptives.count(flatDataCollection);
        if (n <= 3) {
            throw new IllegalArgumentException("The provided collection must have more than 3 elements.");
        }
        double kurtosisSE = Math.sqrt(24.0 / (double)n);
        return kurtosisSE;
    }

    public static double skewness(FlatDataCollection flatDataCollection) {
        int n = Descriptives.count(flatDataCollection);
        if (n <= 1) {
            throw new IllegalArgumentException("The provided collection must have more than 1 elements.");
        }
        double mean = Descriptives.mean(flatDataCollection);
        double m3 = Descriptives.moment(flatDataCollection, 3, mean);
        double variance = Descriptives.variance(flatDataCollection, false);
        double skewness = m3 / Math.pow(variance, 1.5);
        return skewness;
    }

    public static double skewnessSE(FlatDataCollection flatDataCollection) {
        int n = Descriptives.count(flatDataCollection);
        if (n <= 2) {
            throw new IllegalArgumentException("The provided collection must have more than 2 elements.");
        }
        double skewnessSE = Math.sqrt(6.0 * (double)n * ((double)n - 1.0) / (((double)n - 2.0) * ((double)n + 1.0) * ((double)n + 3.0)));
        return skewnessSE;
    }

    public static AssociativeArray percentiles(FlatDataCollection flatDataCollection, int cutPoints) {
        double[] doubleArray = flatDataCollection.stream().filter(x -> x != null).mapToDouble(TypeInference::toDouble).toArray();
        int n = doubleArray.length;
        if (n <= 0 || cutPoints <= 0 || n < cutPoints) {
            throw new IllegalArgumentException("All the parameters must be positive and n larger than cutPoints.");
        }
        Arrays.sort(doubleArray);
        AssociativeArray percintiles = new AssociativeArray();
        double counter = 1.0;
        while (true) {
            double perc = counter / (double)cutPoints;
            Double tc2 = ((double)n + 1.0) * perc;
            int CCk2 = tc2.intValue();
            int CCk2_plus1 = CCk2 + 1;
            int Ck2 = CCk2 - 1;
            int Ck2_plus1 = CCk2_plus1 - 1;
            double g2Star = tc2 - (double)CCk2;
            if (Ck2 >= doubleArray.length) break;
            Double key = 100.0 * perc;
            Double Ck2Value = doubleArray[Ck2];
            if (Ck2_plus1 >= doubleArray.length) {
                percintiles.put(key, Ck2Value);
                break;
            }
            Double Ck2_plus1Value = doubleArray[Ck2_plus1];
            percintiles.put(key, (1.0 - g2Star) * Ck2Value + g2Star * Ck2_plus1Value);
            counter += 1.0;
        }
        return percintiles;
    }

    public static AssociativeArray quartiles(FlatDataCollection flatDataCollection) {
        return Descriptives.percentiles(flatDataCollection, 4);
    }

    public static double covariance(TransposeDataList transposeDataList, boolean isSample) {
        if (transposeDataList.size() != 2) {
            throw new IllegalArgumentException("The collection must contain observations from 2 groups.");
        }
        double covariance = 0.0;
        Object[] keys = transposeDataList.keySet().toArray();
        Object keyX = keys[0];
        Object keyY = keys[1];
        FlatDataCollection flatDataCollectionX = transposeDataList.get(keyX).toFlatDataCollection();
        FlatDataCollection flatDataCollectionY = transposeDataList.get(keyY).toFlatDataCollection();
        int n = flatDataCollectionX.size();
        if (n <= 1 || n != flatDataCollectionY.size()) {
            throw new IllegalArgumentException("The number of observations in each group must be equal and larger than 1.");
        }
        double meanX = Descriptives.mean(flatDataCollectionX);
        double meanY = Descriptives.mean(flatDataCollectionY);
        Iterator<Double> iteratorX = flatDataCollectionX.iteratorDouble();
        Iterator<Double> iteratorY = flatDataCollectionY.iteratorDouble();
        while (iteratorX.hasNext() && iteratorY.hasNext()) {
            covariance += (iteratorX.next() - meanX) * (iteratorY.next() - meanY);
        }
        covariance = isSample ? (covariance /= (double)n - 1.0) : (covariance /= (double)n);
        return covariance;
    }

    public static double autocorrelation(FlatDataList flatDataList, int lags) {
        int n = Descriptives.count(flatDataList);
        if (n <= 0 || lags <= 0 || n < lags) {
            throw new IllegalArgumentException("All the parameters must be positive and n larger than lags.");
        }
        FlatDataCollection flatDataCollection = flatDataList.toFlatDataCollection();
        double mean = Descriptives.mean(flatDataCollection);
        double variance = Descriptives.variance(flatDataCollection, true);
        double Ak = 0.0;
        int maxI = n - lags;
        for (int i = 0; i < maxI; ++i) {
            Ak += (flatDataList.getDouble(i) - mean) * (flatDataList.getDouble(i + lags) - mean);
        }
        double autocorrelation = (Ak /= (double)(n - lags)) / variance;
        return autocorrelation;
    }

    public static AssociativeArray frequencies(FlatDataCollection flatDataCollection) {
        AssociativeArray frequencies = new AssociativeArray();
        for (Object value : flatDataCollection) {
            Object counter = frequencies.get(value);
            if (counter == null) {
                frequencies.put(value, 1);
                continue;
            }
            frequencies.put(value, ((Number)counter).intValue() + 1);
        }
        return frequencies;
    }

    public static FlatDataCollection mode(FlatDataCollection flatDataCollection) {
        AssociativeArray frequencies = Descriptives.frequencies(flatDataCollection);
        int maxCounter = 0;
        FlatDataList modeList = new FlatDataList();
        for (Map.Entry<Object, Object> entry : frequencies.entrySet()) {
            Object key = entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            if (maxCounter == count) {
                modeList.add(key);
                continue;
            }
            if (maxCounter >= count) continue;
            maxCounter = count;
            modeList.clear();
            modeList.add(key);
        }
        return modeList.toFlatDataCollection();
    }

    public static void normalize(AssociativeArray associativeArray) {
        double sum = 0.0;
        for (Map.Entry<Object, Object> entry : associativeArray.entrySet()) {
            Double value = TypeInference.toDouble(entry.getValue());
            associativeArray.put(entry.getKey(), value);
            sum += value.doubleValue();
        }
        if (sum != 0.0) {
            for (Map.Entry<Object, Object> entry : associativeArray.entrySet()) {
                associativeArray.put(entry.getKey(), TypeInference.toDouble(entry.getValue()) / sum);
            }
        }
    }

    public static void normalizeExp(AssociativeArray associativeArray) {
        double max = Descriptives.max(associativeArray.toFlatDataCollection());
        double sum = 0.0;
        for (Map.Entry<Object, Object> entry : associativeArray.entrySet()) {
            Double value = Math.exp(TypeInference.toDouble(entry.getValue()) - max);
            associativeArray.put(entry.getKey(), value);
            sum += value.doubleValue();
        }
        if (sum != 0.0) {
            for (Map.Entry<Object, Object> entry : associativeArray.entrySet()) {
                associativeArray.put(entry.getKey(), TypeInference.toDouble(entry.getValue()) / sum);
            }
        }
    }
}

