/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning.modelselection.metrics;

import com.datumbox.framework.common.dataobjects.FlatDataList;
import com.datumbox.framework.common.dataobjects.TypeInference;
import com.datumbox.framework.core.common.dataobjects.Dataframe;
import com.datumbox.framework.core.common.dataobjects.Record;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelselection.AbstractMetrics;
import com.datumbox.framework.core.statistics.distributions.ContinuousDistributions;
import com.datumbox.framework.core.statistics.nonparametrics.onesample.Lilliefors;
import com.datumbox.framework.core.statistics.parametrics.onesample.DurbinWatson;
import java.util.List;

public class LinearRegressionMetrics
extends AbstractMetrics {
    private static final long serialVersionUID = 1L;
    private double RSquare = 0.0;
    private double RSquareAdjusted = 0.0;
    private double SSE = 0.0;
    private double SSR = 0.0;
    private double SST = 0.0;
    private double dfRegression = 0.0;
    private double dfResidual = 0.0;
    private double dfTotal = 0.0;
    private double F = 0.0;
    private double FPValue = 0.0;
    private double StdErrorOfEstimate = 0.0;
    private double DW = 0.0;
    private double NormalResiduals = 0.0;

    public double getRSquare() {
        return this.RSquare;
    }

    public double getRSquareAdjusted() {
        return this.RSquareAdjusted;
    }

    public double getSSE() {
        return this.SSE;
    }

    public double getSSR() {
        return this.SSR;
    }

    public double getSST() {
        return this.SST;
    }

    public double getDfRegression() {
        return this.dfRegression;
    }

    public double getDfResidual() {
        return this.dfResidual;
    }

    public double getDfTotal() {
        return this.dfTotal;
    }

    public double getF() {
        return this.F;
    }

    public double getFPValue() {
        return this.FPValue;
    }

    public double getStdErrorOfEstimate() {
        return this.StdErrorOfEstimate;
    }

    public double getDW() {
        return this.DW;
    }

    public double getNormalResiduals() {
        return this.NormalResiduals;
    }

    public LinearRegressionMetrics(Dataframe predictedData) {
        super(predictedData);
        int n = predictedData.size();
        FlatDataList errorList = new FlatDataList();
        double Ybar = 0.0;
        for (Object r : predictedData) {
            Ybar += TypeInference.toDouble(((Record)r).getY()) / (double)n;
            errorList.add(TypeInference.toDouble(((Record)r).getY()) - TypeInference.toDouble(((Record)r).getYPredicted()));
        }
        this.DW = DurbinWatson.calculateScore(errorList);
        for (Object r : predictedData) {
            this.SSE += Math.pow(TypeInference.toDouble(((Record)r).getY()) - TypeInference.toDouble(((Record)r).getYPredicted()), 2.0);
        }
        boolean normalResiduals = Lilliefors.test(errorList.toFlatDataCollection(), "normalDistribution", 0.05);
        this.NormalResiduals = normalResiduals ? 0.0 : 1.0;
        for (Record r : predictedData) {
            this.SSR += Math.pow(TypeInference.toDouble(r.getY()) - Ybar, 2.0);
        }
        this.SST = this.SSR + this.SSE;
        this.RSquare = this.SSR / this.SST;
        int d = predictedData.xColumnSize() + 1;
        int p = d - 1;
        this.RSquareAdjusted = 1.0 - ((double)n - 1.0) / ((double)(n - p) - 1.0) * (1.0 - this.RSquare);
        this.dfTotal = (double)n - 1.0;
        this.dfRegression = (double)d - 1.0;
        this.dfResidual = Math.max((double)(n - d), 0.0);
        this.F = this.SSR / this.dfRegression / (this.SSE / this.dfResidual);
        this.FPValue = 1.0;
        if (n > d) {
            this.FPValue = ContinuousDistributions.fCdf(this.F, (int)this.dfRegression, (int)this.dfResidual);
        }
        if (this.dfResidual > 0.0) {
            this.StdErrorOfEstimate = Math.sqrt(this.SSE / this.dfResidual);
        }
    }

    public LinearRegressionMetrics(List<LinearRegressionMetrics> validationMetricsList) {
        super(validationMetricsList);
        if (!validationMetricsList.isEmpty()) {
            int k = validationMetricsList.size();
            for (LinearRegressionMetrics vmSample : validationMetricsList) {
                this.RSquare += vmSample.getRSquare() / (double)k;
                this.RSquareAdjusted += vmSample.getRSquareAdjusted() / (double)k;
                this.SSE += vmSample.getSSE() / (double)k;
                this.SSR += vmSample.getSSR() / (double)k;
                this.SST += vmSample.getSST() / (double)k;
                this.dfRegression += vmSample.getDfRegression() / (double)k;
                this.dfResidual += vmSample.getDfResidual() / (double)k;
                this.dfTotal += vmSample.getDfTotal() / (double)k;
                this.F += vmSample.getF() / (double)k;
                this.FPValue += vmSample.getFPValue() / (double)k;
                this.StdErrorOfEstimate += vmSample.getStdErrorOfEstimate() / (double)k;
                this.DW += vmSample.getDW() / (double)k;
                this.NormalResiduals += vmSample.getNormalResiduals() / (double)k;
            }
        }
    }

    public String toString() {
        String sep = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(":").append(sep);
        sb.append("RSqure=").append(this.RSquare).append(sep);
        sb.append("RSquareAdjusted=").append(this.RSquareAdjusted).append(sep);
        sb.append("SSE=").append(this.SSE).append(sep);
        sb.append("SSR=").append(this.SSR).append(sep);
        sb.append("SST=").append(this.SST).append(sep);
        sb.append("dfRegression=").append(this.dfRegression).append(sep);
        sb.append("dfResidual=").append(this.dfResidual).append(sep);
        sb.append("dfTotal=").append(this.dfTotal).append(sep);
        sb.append("F=").append(this.F).append(sep);
        sb.append("FPValue=").append(this.FPValue).append(sep);
        sb.append("StdErrorOfEstimate=").append(this.StdErrorOfEstimate).append(sep);
        sb.append("DW=").append(this.DW).append(sep);
        sb.append("NormalResiduals=").append(this.NormalResiduals).append(sep);
        return sb.toString();
    }
}

