/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.machinelearning;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.core.common.interfaces.Parameterizable;
import com.datumbox.framework.core.machinelearning.common.interfaces.Trainable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class MLBuilder {
    public static <T extends Trainable, TP extends Parameterizable> T create(TP trainingParameters, Configuration configuration) {
        try {
            Class<?> aClass = trainingParameters.getClass().getEnclosingClass();
            Constructor<?> constructor = aClass.getDeclaredConstructor(trainingParameters.getClass(), Configuration.class);
            constructor.setAccessible(true);
            return (T)((Trainable)constructor.newInstance(trainingParameters, configuration));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T extends Trainable> T load(Class<T> aClass, String storageName, Configuration configuration) {
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(String.class, Configuration.class);
            constructor.setAccessible(true);
            return (T)((Trainable)constructor.newInstance(storageName, configuration));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }
}

