/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.core.common.utilities;

import com.datumbox.framework.common.utilities.RandomGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PHPMethods {
    private static final Pattern LTRIM = Pattern.compile("^\\s+");
    private static final Pattern RTRIM = Pattern.compile("\\s+$");

    public static String ltrim(String s) {
        return LTRIM.matcher(s).replaceAll("");
    }

    public static String rtrim(String s) {
        return RTRIM.matcher(s).replaceAll("");
    }

    public static int substr_count(String string, String substring) {
        if (substring.length() == 1) {
            return PHPMethods.substr_count(string, substring.charAt(0));
        }
        int count = 0;
        int idx = 0;
        while ((idx = string.indexOf(substring, idx)) != -1) {
            ++idx;
            ++count;
        }
        return count;
    }

    public static int substr_count(String string, char character) {
        int count = 0;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != character) continue;
            ++count;
        }
        return count;
    }

    public static String preg_replace(String regex, String replacement, String subject) {
        Pattern p = Pattern.compile(regex);
        return PHPMethods.preg_replace(p, replacement, subject);
    }

    public static String preg_replace(Pattern pattern, String replacement, String subject) {
        Matcher m = pattern.matcher(subject);
        StringBuffer sb = new StringBuffer(subject.length());
        while (m.find()) {
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static int preg_match(String regex, String subject) {
        Pattern p = Pattern.compile(regex);
        return PHPMethods.preg_match(p, subject);
    }

    public static int preg_match(Pattern pattern, String subject) {
        int matches = 0;
        Matcher m = pattern.matcher(subject);
        while (m.find()) {
            ++matches;
        }
        return matches;
    }

    public static double round(double d, int i) {
        double multiplier = Math.pow(10.0, i);
        return (double)Math.round(d * multiplier) / multiplier;
    }

    public static double log(double d, double base) {
        if (base == 1.0 || base <= 0.0) {
            throw new IllegalArgumentException("Invalid base for logarithm.");
        }
        return Math.log(d) / Math.log(base);
    }

    public static int mt_rand() {
        return PHPMethods.mt_rand(0, Integer.MAX_VALUE);
    }

    public static int mt_rand(int min, int max) {
        return min + (int)(RandomGenerator.getThreadLocalRandom().nextDouble() * (double)(max - min + 1));
    }

    public static double mt_rand(double min, double max) {
        return min + RandomGenerator.getThreadLocalRandom().nextDouble() * (max - min);
    }

    public static <K, V> Map<V, K> array_flip(Map<K, V> map) {
        HashMap<V, K> flipped = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            flipped.put(entry.getValue(), entry.getKey());
        }
        return flipped;
    }

    public static <T> void shuffle(T[] array) {
        PHPMethods.shuffle(array, RandomGenerator.getThreadLocalRandom());
    }

    public static <T> void shuffle(T[] array, Random rnd) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            T tmp = array[index];
            array[index] = array[i];
            array[i] = tmp;
        }
    }

    public static <T extends Comparable<T>> Integer[] asort(T[] array) {
        return PHPMethods._asort(array, (boolean)false);
    }

    public static <T extends Comparable<T>> Integer[] arsort(T[] array) {
        return PHPMethods._asort(array, (boolean)true);
    }

    private static <T extends Comparable<T>> Integer[] _asort(T[] array, boolean reverse) {
        Integer[] indexes = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            indexes[i] = i;
        }
        Comparator c = (index1, index2) -> array[index1].compareTo(array[index2]);
        c = reverse ? Collections.reverseOrder(c) : c;
        Arrays.sort(indexes, c);
        PHPMethods.arrangeByIndex(array, indexes);
        return indexes;
    }

    public static <T> void arrangeByIndex(T[] array, Integer[] indexes) {
        if (array.length != indexes.length) {
            throw new IllegalArgumentException("The length of the two arrays must match.");
        }
        for (int i = 0; i < array.length; ++i) {
            int index = indexes[i];
            T tmp = array[i];
            array[i] = array[index];
            array[index] = tmp;
        }
    }

    public static double[] array_clone(double[] a) {
        if (a == null) {
            return a;
        }
        return Arrays.copyOf(a, a.length);
    }

    public static double[][] array_clone(double[][] a) {
        if (a == null) {
            return a;
        }
        double[][] copy = new double[a.length][];
        for (int i = 0; i < a.length; ++i) {
            copy[i] = Arrays.copyOf(a[i], a[i].length);
        }
        return copy;
    }
}

