/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.concurrency;

import com.datumbox.framework.common.interfaces.Configurable;
import java.util.Properties;

public class ConcurrencyConfiguration
implements Configurable {
    public static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private boolean parallelized = true;
    private Integer maxNumberOfThreadsPerTask = AVAILABLE_PROCESSORS;

    public boolean isParallelized() {
        return this.parallelized;
    }

    public void setParallelized(boolean parallelized) {
        this.parallelized = parallelized;
    }

    public Integer getMaxNumberOfThreadsPerTask() {
        return this.maxNumberOfThreadsPerTask;
    }

    public void setMaxNumberOfThreadsPerTask(Integer maxNumberOfThreadsPerTask) {
        if (maxNumberOfThreadsPerTask < 0) {
            throw new IllegalArgumentException("The max number of threads can not be negative.");
        }
        this.maxNumberOfThreadsPerTask = maxNumberOfThreadsPerTask == 0 ? Integer.valueOf(AVAILABLE_PROCESSORS) : Integer.valueOf(Math.min(maxNumberOfThreadsPerTask, 4 * AVAILABLE_PROCESSORS));
    }

    @Override
    public void load(Properties properties) {
        this.setParallelized("true".equalsIgnoreCase(properties.getProperty("concurrencyConfiguration.parallelized")));
        this.setMaxNumberOfThreadsPerTask(Integer.parseInt(properties.getProperty("concurrencyConfiguration.maxNumberOfThreadsPerTask")));
        if (!this.isParallelized()) {
            this.setMaxNumberOfThreadsPerTask(1);
        } else if (this.getMaxNumberOfThreadsPerTask() == 1) {
            this.setParallelized(false);
        }
    }
}

