/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.ui.ExtendedDrawable;

public class ScalingExtendedDrawable
implements ExtendedDrawable {
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private ExtendedDrawable drawable;

    public void draw(Graphics2D g2, Rectangle2D area) {
        if (this.drawable == null) {
            return;
        }
        Graphics2D derived = (Graphics2D)g2.create();
        derived.scale(this.scaleX, this.scaleY);
        Rectangle2D scaledArea = (Rectangle2D)area.clone();
        scaledArea.setRect(scaledArea.getX() * (double)this.scaleX, scaledArea.getY() * (double)this.scaleY, scaledArea.getWidth() * (double)this.scaleX, scaledArea.getHeight() * (double)this.scaleY);
        this.drawable.draw(derived, scaledArea);
        derived.dispose();
    }

    public ExtendedDrawable getDrawable() {
        return this.drawable;
    }

    public Dimension getPreferredSize() {
        if (this.drawable == null) {
            return new Dimension(0, 0);
        }
        Dimension dim = this.drawable.getPreferredSize();
        if (dim == null) {
            return null;
        }
        dim.setSize((double)this.scaleX * dim.getWidth(), (double)this.scaleY * dim.getHeight());
        return dim;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public boolean isPreserveAspectRatio() {
        if (this.drawable == null) {
            return false;
        }
        return this.drawable.isPreserveAspectRatio();
    }

    public void setDrawable(ExtendedDrawable drawable) {
        this.drawable = drawable;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }
}

