/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.lang.reflect.Field;
import org.jfree.util.Log;

public final class PageFormatFactory {
    public static final int DOTS_PER_INCH = 72;
    public static final int[] PAPER11X17 = new int[]{792, 1224};
    public static final int[] PAPER10X11 = new int[]{720, 792};
    public static final int[] PAPER10X13 = new int[]{720, 936};
    public static final int[] PAPER10X14 = new int[]{720, 1008};
    public static final int[] PAPER12X11 = new int[]{864, 792};
    public static final int[] PAPER15X11 = new int[]{1080, 792};
    public static final int[] PAPER7X9 = new int[]{504, 648};
    public static final int[] PAPER8X10 = new int[]{576, 720};
    public static final int[] PAPER9X11 = new int[]{648, 792};
    public static final int[] PAPER9X12 = new int[]{648, 864};
    public static final int[] A0 = new int[]{2384, 3370};
    public static final int[] A1 = new int[]{1684, 2384};
    public static final int[] A2 = new int[]{1191, 1684};
    public static final int[] A3 = new int[]{842, 1191};
    public static final int[] A3_TRANSVERSE = new int[]{842, 1191};
    public static final int[] A3_EXTRA = new int[]{913, 1262};
    public static final int[] A3_EXTRATRANSVERSE = new int[]{913, 1262};
    public static final int[] A3_ROTATED = new int[]{1191, 842};
    public static final int[] A4 = new int[]{595, 842};
    public static final int[] A4_TRANSVERSE = new int[]{595, 842};
    public static final int[] A4_EXTRA = new int[]{667, 914};
    public static final int[] A4_PLUS = new int[]{595, 936};
    public static final int[] A4_ROTATED = new int[]{842, 595};
    public static final int[] A4_SMALL = new int[]{595, 842};
    public static final int[] A5 = new int[]{420, 595};
    public static final int[] A5_TRANSVERSE = new int[]{420, 595};
    public static final int[] A5_EXTRA = new int[]{492, 668};
    public static final int[] A5_ROTATED = new int[]{595, 420};
    public static final int[] A6 = new int[]{297, 420};
    public static final int[] A6_ROTATED = new int[]{420, 297};
    public static final int[] A7 = new int[]{210, 297};
    public static final int[] A8 = new int[]{148, 210};
    public static final int[] A9 = new int[]{105, 148};
    public static final int[] A10 = new int[]{73, 105};
    public static final int[] ANSIC = new int[]{1224, 1584};
    public static final int[] ANSID = new int[]{1584, 2448};
    public static final int[] ANSIE = new int[]{2448, 3168};
    public static final int[] ARCHA = new int[]{648, 864};
    public static final int[] ARCHB = new int[]{864, 1296};
    public static final int[] ARCHC = new int[]{1296, 1728};
    public static final int[] ARCHD = new int[]{1728, 2592};
    public static final int[] ARCHE = new int[]{2592, 3456};
    public static final int[] B0 = new int[]{2920, 4127};
    public static final int[] B1 = new int[]{2064, 2920};
    public static final int[] B2 = new int[]{1460, 2064};
    public static final int[] B3 = new int[]{1032, 1460};
    public static final int[] B4 = new int[]{729, 1032};
    public static final int[] B4_ROTATED = new int[]{1032, 729};
    public static final int[] B5 = new int[]{516, 729};
    public static final int[] B5_TRANSVERSE = new int[]{516, 729};
    public static final int[] B5_ROTATED = new int[]{729, 516};
    public static final int[] B6 = new int[]{363, 516};
    public static final int[] B6_ROTATED = new int[]{516, 363};
    public static final int[] B7 = new int[]{258, 363};
    public static final int[] B8 = new int[]{181, 258};
    public static final int[] B9 = new int[]{127, 181};
    public static final int[] B10 = new int[]{91, 127};
    public static final int[] C4 = new int[]{649, 918};
    public static final int[] C5 = new int[]{459, 649};
    public static final int[] C6 = new int[]{323, 459};
    public static final int[] COMM10 = new int[]{297, 684};
    public static final int[] DL = new int[]{312, 624};
    public static final int[] DOUBLEPOSTCARD = new int[]{567, 419};
    public static final int[] DOUBLEPOSTCARD_ROTATED = new int[]{419, 567};
    public static final int[] ENV9 = new int[]{279, 639};
    public static final int[] ENV10 = new int[]{297, 684};
    public static final int[] ENV11 = new int[]{324, 747};
    public static final int[] ENV12 = new int[]{342, 792};
    public static final int[] ENV14 = new int[]{360, 828};
    public static final int[] ENVC0 = new int[]{2599, 3676};
    public static final int[] ENVC1 = new int[]{1837, 2599};
    public static final int[] ENVC2 = new int[]{1298, 1837};
    public static final int[] ENVC3 = new int[]{918, 1296};
    public static final int[] ENVC4 = new int[]{649, 918};
    public static final int[] ENVC5 = new int[]{459, 649};
    public static final int[] ENVC6 = new int[]{323, 459};
    public static final int[] ENVC65 = new int[]{324, 648};
    public static final int[] ENVC7 = new int[]{230, 323};
    public static final int[] ENVCHOU3 = new int[]{340, 666};
    public static final int[] ENVCHOU3_ROTATED = new int[]{666, 340};
    public static final int[] ENVCHOU4 = new int[]{255, 581};
    public static final int[] ENVCHOU4_ROTATED = new int[]{581, 255};
    public static final int[] ENVDL = new int[]{312, 624};
    public static final int[] ENVINVITE = new int[]{624, 624};
    public static final int[] ENVISOB4 = new int[]{708, 1001};
    public static final int[] ENVISOB5 = new int[]{499, 709};
    public static final int[] ENVISOB6 = new int[]{499, 354};
    public static final int[] ENVITALIAN = new int[]{312, 652};
    public static final int[] ENVELOPE = new int[]{312, 652};
    public static final int[] ENVKAKU2 = new int[]{680, 941};
    public static final int[] ENVKAKU2_ROTATED = new int[]{941, 680};
    public static final int[] ENVKAKU3 = new int[]{612, 785};
    public static final int[] ENVKAKU3_ROTATED = new int[]{785, 612};
    public static final int[] ENVMONARCH = new int[]{279, 540};
    public static final int[] ENVPERSONAL = new int[]{261, 468};
    public static final int[] ENVPRC1 = new int[]{289, 468};
    public static final int[] ENVPRC1_ROTATED = new int[]{468, 289};
    public static final int[] ENVPRC2 = new int[]{289, 499};
    public static final int[] ENVPRC2_ROTATED = new int[]{499, 289};
    public static final int[] ENVPRC3 = new int[]{354, 499};
    public static final int[] ENVPRC3_ROTATED = new int[]{499, 354};
    public static final int[] ENVPRC4 = new int[]{312, 590};
    public static final int[] ENVPRC4_ROTATED = new int[]{590, 312};
    public static final int[] ENVPRC5 = new int[]{312, 624};
    public static final int[] ENVPRC5_ROTATED = new int[]{624, 312};
    public static final int[] ENVPRC6 = new int[]{340, 652};
    public static final int[] ENVPRC6_ROTATED = new int[]{652, 340};
    public static final int[] ENVPRC7 = new int[]{454, 652};
    public static final int[] ENVPRC7_ROTATED = new int[]{652, 454};
    public static final int[] ENVPRC8 = new int[]{340, 876};
    public static final int[] ENVPRC8_ROTATED = new int[]{876, 340};
    public static final int[] ENVPRC9 = new int[]{649, 918};
    public static final int[] ENVPRC9_ROTATED = new int[]{918, 649};
    public static final int[] ENVPRC10 = new int[]{918, 1298};
    public static final int[] ENVPRC10_ROTATED = new int[]{1298, 918};
    public static final int[] ENVYOU4 = new int[]{298, 666};
    public static final int[] ENVYOU4_ROTATED = new int[]{666, 298};
    public static final int[] EXECUTIVE = new int[]{522, 756};
    public static final int[] FANFOLDUS = new int[]{1071, 792};
    public static final int[] FANFOLDGERMAN = new int[]{612, 864};
    public static final int[] FANFOLDGERMANLEGAL = new int[]{612, 936};
    public static final int[] FOLIO = new int[]{595, 935};
    public static final int[] ISOB0 = new int[]{2835, 4008};
    public static final int[] ISOB1 = new int[]{2004, 2835};
    public static final int[] ISOB2 = new int[]{1417, 2004};
    public static final int[] ISOB3 = new int[]{1001, 1417};
    public static final int[] ISOB4 = new int[]{709, 1001};
    public static final int[] ISOB5 = new int[]{499, 709};
    public static final int[] ISOB5_EXTRA = new int[]{570, 782};
    public static final int[] ISOB6 = new int[]{354, 499};
    public static final int[] ISOB7 = new int[]{249, 354};
    public static final int[] ISOB8 = new int[]{176, 249};
    public static final int[] ISOB9 = new int[]{125, 176};
    public static final int[] ISOB10 = new int[]{88, 125};
    public static final int[] LEDGER = new int[]{1224, 792};
    public static final int[] LEGAL = new int[]{612, 1008};
    public static final int[] LEGAL_EXTRA = new int[]{684, 1080};
    public static final int[] LETTER = new int[]{612, 792};
    public static final int[] LETTER_TRANSVERSE = new int[]{612, 792};
    public static final int[] LETTER_EXTRA = new int[]{684, 864};
    public static final int[] LETTER_EXTRATRANSVERSE = new int[]{684, 864};
    public static final int[] LETTER_PLUS = new int[]{612, 914};
    public static final int[] LETTER_ROTATED = new int[]{792, 612};
    public static final int[] LETTER_SMALL = new int[]{612, 792};
    public static final int[] MONARCH = ENVMONARCH;
    public static final int[] NOTE = new int[]{612, 792};
    public static final int[] POSTCARD = new int[]{284, 419};
    public static final int[] POSTCARD_ROTATED = new int[]{419, 284};
    public static final int[] PRC16K = new int[]{414, 610};
    public static final int[] PRC16K_ROTATED = new int[]{610, 414};
    public static final int[] PRC32K = new int[]{275, 428};
    public static final int[] PRC32K_ROTATED = new int[]{428, 275};
    public static final int[] PRC32K_BIG = new int[]{275, 428};
    public static final int[] PRC32K_BIGROTATED = new int[]{428, 275};
    public static final int[] QUARTO = new int[]{610, 780};
    public static final int[] STATEMENT = new int[]{396, 612};
    public static final int[] SUPERA = new int[]{643, 1009};
    public static final int[] SUPERB = new int[]{864, 1380};
    public static final int[] TABLOID = new int[]{792, 1224};
    public static final int[] TABLOIDEXTRA = new int[]{864, 1296};
    private static PageFormatFactory singleton;

    private PageFormatFactory() {
    }

    public double convertInchToPoints(double inches) {
        return inches * 72.0;
    }

    public double convertMmToPoints(double mm) {
        return mm * 0.28346456692913385 * 10.0;
    }

    public PageFormat createPageFormat(Paper paper, int orientation) {
        if (paper == null) {
            throw new NullPointerException("Paper given must not be null");
        }
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        pf.setOrientation(orientation);
        return pf;
    }

    public PageFormat createPageFormat(Object[] data) {
        Integer orientation = (Integer)data[0];
        float[] dim = (float[])data[1];
        float[] rect = (float[])data[2];
        Paper p = new Paper();
        p.setSize(dim[0], dim[1]);
        p.setImageableArea(rect[0], rect[1], rect[2], rect[3]);
        PageFormat format = new PageFormat();
        format.setPaper(p);
        format.setOrientation(orientation);
        return format;
    }

    public Paper createPaper(int width, int height) {
        Paper p = new Paper();
        p.setSize(width, height);
        this.setBorders(p, 0.0, 0.0, 0.0, 0.0);
        return p;
    }

    public Paper createPaper(String name) {
        try {
            Field f = this.getClass().getDeclaredField(name);
            Object o = f.get(this);
            if (!(o instanceof int[])) {
                return null;
            }
            int[] pageformat = (int[])o;
            return this.createPaper(pageformat);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public Paper createPaper(int[] papersize) {
        if (papersize.length != 2) {
            throw new IllegalArgumentException("Paper must have a width and a height");
        }
        return this.createPaper(papersize[0], papersize[1]);
    }

    public double getBottomBorder(Paper p) {
        return p.getHeight() - (p.getImageableY() + p.getImageableHeight());
    }

    public static PageFormatFactory getInstance() {
        if (singleton == null) {
            singleton = new PageFormatFactory();
        }
        return singleton;
    }

    public double getLeftBorder(Paper p) {
        return p.getImageableX();
    }

    public double getRightBorder(Paper p) {
        return p.getWidth() - (p.getImageableX() + p.getImageableWidth());
    }

    public double getTopBorder(Paper p) {
        return p.getImageableY();
    }

    public static boolean isEqual(PageFormat pf1, PageFormat pf2) {
        if (pf1 == pf2) {
            return true;
        }
        if (pf1 == null || pf2 == null) {
            return false;
        }
        if (pf1.getOrientation() != pf2.getOrientation()) {
            return false;
        }
        Paper p1 = pf1.getPaper();
        Paper p2 = pf2.getPaper();
        if (p1.getWidth() != p2.getWidth()) {
            return false;
        }
        if (p1.getHeight() != p2.getHeight()) {
            return false;
        }
        if (p1.getImageableX() != p2.getImageableX()) {
            return false;
        }
        if (p1.getImageableY() != p2.getImageableY()) {
            return false;
        }
        if (p1.getImageableWidth() != p2.getImageableWidth()) {
            return false;
        }
        return p1.getImageableHeight() == p2.getImageableHeight();
    }

    public static void logPageFormat(PageFormat pf) {
        Log.debug((Object)("PageFormat: Width: " + pf.getWidth() + " Height: " + pf.getHeight()));
        Log.debug((Object)("PageFormat: Image: X " + pf.getImageableX() + " Y " + pf.getImageableY() + " W: " + pf.getImageableWidth() + " H: " + pf.getImageableHeight()));
        Log.debug((Object)("PageFormat: Margins: X " + pf.getImageableX() + " Y " + pf.getImageableY() + " X2: " + (pf.getImageableWidth() + pf.getImageableX()) + " Y2: " + (pf.getImageableHeight() + pf.getImageableY())));
    }

    public static void logPaper(Paper pf) {
        Log.debug((Object)("Paper: Width: " + pf.getWidth() + " Height: " + pf.getHeight()));
        Log.debug((Object)("Paper: Image: X " + pf.getImageableX() + " Y " + pf.getImageableY() + " H: " + pf.getImageableHeight() + " W: " + pf.getImageableWidth()));
    }

    public Object[] resolvePageFormat(PageFormat format) {
        Integer orientation = new Integer(format.getOrientation());
        Paper p = format.getPaper();
        float[] fdim = new float[]{(float)p.getWidth(), (float)p.getHeight()};
        float[] rect = new float[]{(float)p.getImageableX(), (float)p.getImageableY(), (float)p.getImageableWidth(), (float)p.getImageableHeight()};
        return new Object[]{orientation, fdim, rect};
    }

    public void setBorders(Paper paper, double top, double left, double bottom, double right) {
        double w = paper.getWidth() - (right + left);
        double h = paper.getHeight() - (bottom + top);
        paper.setImageableArea(left, top, w, h);
    }

    public void setBordersInch(Paper paper, double top, double left, double bottom, double right) {
        this.setBorders(paper, this.convertInchToPoints(top), this.convertInchToPoints(left), this.convertInchToPoints(bottom), this.convertInchToPoints(right));
    }

    public void setBordersMm(Paper paper, double top, double left, double bottom, double right) {
        this.setBorders(paper, this.convertMmToPoints(top), this.convertMmToPoints(left), this.convertMmToPoints(bottom), this.convertMmToPoints(right));
    }
}

