/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.resourceloader;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.report.resourceloader.DrawableFactoryModule;
import org.jfree.report.resourceloader.ImageFactoryModule;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.Drawable;

public class WmfImageFactoryModule
implements ImageFactoryModule,
DrawableFactoryModule {
    private static final String[] MIMETYPES = new String[]{"application/x-msmetafile", "application/wmf", "application/x-wmf", "image/wmf", "image/x-wmf", "image/x-win-metafile", "zz-application/zz-winassoc-wmf"};

    public boolean canHandleResourceByContent(byte[] content) {
        return content[0] == 215 && content[1] == 205;
    }

    public boolean canHandleResourceByMimeType(String name) {
        int i = 0;
        while (i < MIMETYPES.length) {
            if (name.equals(MIMETYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canHandleResourceByName(String name) {
        return StringUtil.endsWithIgnoreCase(name, ".wmf");
    }

    public Drawable createDrawable(byte[] imageData, String fileName, String mimeType) throws IOException {
        WmfFile wmfFile = new WmfFile((InputStream)new ByteArrayInputStream(imageData), -1, -1);
        return wmfFile;
    }

    public Image createImage(byte[] imageData, String fileName, String mimeType) throws IOException {
        WmfFile wmfFile = new WmfFile((InputStream)new ByteArrayInputStream(imageData), -1, -1);
        return wmfFile.replay();
    }

    public int getHeaderFingerprintSize() {
        return 2;
    }
}

