/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import org.jfree.report.Band;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.simple.readhandlers.RootLevelBandReadHandler;
import org.jfree.report.style.BandStyleKeys;
import org.jfree.xml.ParserUtil;
import org.xml.sax.SAXException;

public class PageBandReadHandler
extends RootLevelBandReadHandler {
    public static final String ON_FIRST_PAGE_ATTR = "onfirstpage";
    public static final String ON_LAST_PAGE_ATTR = "onlastpage";

    public PageBandReadHandler(Band band) {
        super(band);
    }

    private void handleOnFirstPage(PropertyAttributes attr) {
        String breakBeforeAttr = attr.getValue(ON_FIRST_PAGE_ATTR);
        if (breakBeforeAttr != null) {
            boolean breakBefore = ParserUtil.parseBoolean((String)breakBeforeAttr, (boolean)false);
            this.getBand().getStyle().setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, breakBefore);
        }
    }

    private void handleOnLastPage(PropertyAttributes attr) {
        String breakBeforeAttr = attr.getValue(ON_LAST_PAGE_ATTR);
        if (breakBeforeAttr != null) {
            boolean breakBefore = ParserUtil.parseBoolean((String)breakBeforeAttr, (boolean)false);
            this.getBand().getStyle().setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, breakBefore);
        }
    }

    protected boolean isManualBreakAllowed() {
        return false;
    }

    protected void startParsing(PropertyAttributes attr) throws SAXException {
        super.startParsing(attr);
        this.handleOnFirstPage(attr);
        this.handleOnLastPage(attr);
    }
}

