/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.content.ShapeTransform;
import org.jfree.report.elementfactory.StaticShapeElementFactory;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.util.StrokeUtility;
import org.jfree.util.Log;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class LineReadHandler
extends AbstractPropertyXmlReadHandler {
    private Element element;
    private static final String NAME_ATT = "name";
    private static final String COLOR_ATT = "color";

    public Object getObject() throws XmlReaderException {
        return this.element;
    }

    private Stroke readStroke(PropertyAttributes atts) {
        String strokeStyle = atts.getValue("stroke-style");
        float weight = ParserUtil.parseFloat((String)atts.getValue("weight"), (float)1.0f);
        Stroke stroke = null;
        if ("dashed".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(1, weight);
        } else if ("dotted".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(2, weight);
        } else if ("dot-dot-dash".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(4, weight);
        } else if ("dot-dash".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(3, weight);
        } else if ("solid".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(0, weight);
        }
        return stroke;
    }

    protected void startParsing(PropertyAttributes atts) throws SAXException, XmlReaderException {
        String name = atts.getValue(NAME_ATT);
        Color c = ParserUtil.parseColor((String)atts.getValue(COLOR_ATT));
        float x1 = ParserUtil.parseRelativeFloat((String)atts.getValue("x1"), (String)"Element x1 not specified");
        float y1 = ParserUtil.parseRelativeFloat((String)atts.getValue("y1"), (String)"Element y1 not specified");
        float x2 = ParserUtil.parseRelativeFloat((String)atts.getValue("x2"), (String)"Element x2 not specified");
        float y2 = ParserUtil.parseRelativeFloat((String)atts.getValue("y2"), (String)"Element y2 not specified");
        Stroke stroke = this.readStroke(atts);
        String widthValue = atts.getValue("width");
        float width = widthValue != null ? ParserUtil.parseRelativeFloat((String)widthValue, (String)"Width is invalid") : x2 - x1;
        String heightValue = atts.getValue("height");
        float height = heightValue != null ? ParserUtil.parseRelativeFloat((String)heightValue, (String)"Height is invalid") : y2 - y1;
        if (x1 == x2 && y1 == y2) {
            Log.warn((Object)"creating a horizontal line with 'x1 == x2 && y1 == y2' is deprecated. Use relative coordinates instead.");
            this.element = StaticShapeElementFactory.createHorizontalLine(name, c, stroke, y2);
        } else {
            Rectangle2D.Float bounds = new Rectangle2D.Float(x1, y1, width, height);
            Line2D.Float line = new Line2D.Float(x1, y1, x2, y2);
            Rectangle2D shapeBounds = line.getBounds2D();
            Shape transformedShape = ShapeTransform.translateShape(line, -shapeBounds.getX(), -shapeBounds.getY());
            this.element = StaticShapeElementFactory.createShapeElement(name, bounds, c, stroke, transformedShape, true, false, true, false);
        }
    }

    protected void storeComments() throws SAXException {
        CommentHintPath commentHintPath = new CommentHintPath(this.element);
        this.defaultStoreComments(commentHintPath);
    }
}

