/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.readhandlers;

import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.DataTarget;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.jfree.report.modules.parser.ext.readhandlers.CompoundObjectReadHandler;
import org.jfree.xml.ParseException;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class DataSourceReadHandler
extends CompoundObjectReadHandler {
    private DataSourceReadHandler childHandler;

    public DataSourceReadHandler(CommentHintPath commentPath) {
        super(null, commentPath);
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals("datasource")) {
            this.childHandler = new DataSourceReadHandler(this.getCommentHintPath().getInstance());
            return this.childHandler;
        }
        return super.getHandlerForChild(tagName, atts);
    }

    public Object getObject() throws XmlReaderException {
        DataSource ds = (DataSource)super.getObject();
        if (this.childHandler != null && ds instanceof DataTarget) {
            DataTarget dt = (DataTarget)((Object)ds);
            dt.setDataSource((DataSource)this.childHandler.getObject());
        }
        return ds;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException, XmlReaderException {
        String typeName = attrs.getValue("type");
        if (typeName == null) {
            throw new ParseException("The datasource type must be specified", this.getRootHandler().getLocator());
        }
        DataSourceCollector fc = (DataSourceCollector)this.getRootHandler().getHelperObject("::datasource-factory");
        ObjectDescription od = fc.getDataSourceDescription(typeName);
        if (od == null) {
            throw new ParseException("The specified DataSource type is not defined");
        }
        this.setObjectDescription(od);
    }
}

