/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.base.common;

import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.base.PropertyStringReadHandler;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ConverterRegistry;
import org.jfree.report.util.beans.StringValueConverter;
import org.jfree.report.util.beans.ValueConverter;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class PropertyReferenceReadHandler
extends PropertyStringReadHandler {
    public static final String CLASS_ATT = "class";
    public static final String NAME_ATT = "name";
    private String propertyName;
    private Object value;
    private ValueConverter valueType;

    public PropertyReferenceReadHandler(CommentHintPath commentHintPath) {
        super(commentHintPath);
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        super.doneParsing();
        try {
            this.value = this.valueType.toPropertyValue(this.getResult());
        }
        catch (BeanException beanException) {
            throw new SAXException("Failed to parse property value.");
        }
    }

    public Object getObject() {
        return this.value;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException, XmlReaderException {
        super.startParsing(attrs);
        this.propertyName = attrs.getValue(NAME_ATT);
        if (this.propertyName == null) {
            throw new ElementDefinitionException("Required attribute 'name' is null.");
        }
        String className = attrs.getValue(CLASS_ATT);
        if (className == null) {
            this.valueType = new StringValueConverter();
        } else {
            try {
                Class<?> c = ObjectUtilities.getClassLoader(((Object)((Object)this)).getClass()).loadClass(className);
                this.valueType = ConverterRegistry.getInstance().getValueConverter(c);
            }
            catch (Exception exception) {
                throw new ElementDefinitionException("Attribute 'class' is invalid.");
            }
        }
        this.getHintPath().addName(this.propertyName);
    }
}

