/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls;

import java.util.ArrayList;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.table.base.LayoutCreator;
import org.jfree.report.modules.output.table.base.ProxyTableCreator;
import org.jfree.report.modules.output.table.base.TableCreator;
import org.jfree.report.modules.output.table.xls.ExcelProcessor;
import org.jfree.report.states.ReportState;

public class AppendingExcelProcessor
extends ExcelProcessor {
    private ArrayList additionalReports = new ArrayList();
    private int reportCount;
    private ProxyTableCreator layoutCreator;
    private ProxyTableCreator tableCreator;

    public AppendingExcelProcessor(JFreeReport report) throws ReportProcessingException {
        super(report);
        this.additionalReports.add(super.getReport());
    }

    public synchronized void addReport(JFreeReport report) {
        report.addExpression(this.getTableWriter());
        this.additionalReports.add(report);
    }

    protected TableCreator createContentCreator() {
        if (this.tableCreator == null) {
            this.tableCreator = new ProxyTableCreator(super.createContentCreator());
        }
        return this.tableCreator;
    }

    protected LayoutCreator createLayoutCreator() {
        if (this.layoutCreator == null) {
            this.layoutCreator = new ProxyTableCreator(super.createLayoutCreator());
        }
        return this.layoutCreator;
    }

    protected JFreeReport getReport() {
        if (this.additionalReports == null) {
            return super.getReport();
        }
        return (JFreeReport)this.additionalReports.get(this.reportCount);
    }

    public int getSize() {
        return this.additionalReports.size();
    }

    public synchronized void processReport() throws ReportProcessingException {
        try {
            ReportState state;
            this.layoutCreator = null;
            this.tableCreator = null;
            ArrayList<ReportState> states = new ArrayList<ReportState>();
            this.createLayoutCreator();
            this.layoutCreator.getParent().open(this.getReport());
            this.reportCount = 0;
            while (this.reportCount < this.getSize()) {
                state = super.repaginate();
                states.add(state);
                ++this.reportCount;
            }
            this.layoutCreator.getParent().close();
            this.reportCount = 0;
            this.createContentCreator();
            this.tableCreator.getParent().open(this.getReport());
            this.reportCount = 0;
            while (this.reportCount < this.getSize()) {
                state = (ReportState)states.get(this.reportCount);
                this.createContent(state);
                ++this.reportCount;
            }
            this.tableCreator.getParent().close();
        }
        finally {
            Object var2_3 = null;
            this.reportCount = 0;
            this.layoutCreator = null;
            this.tableCreator = null;
        }
    }
}

