/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.rtf;

import com.lowagie.text.pdf.BaseFont;
import org.jfree.report.Element;
import org.jfree.report.ImageContainer;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.content.AnchorContentFactoryModule;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.content.DefaultContentFactory;
import org.jfree.report.content.ImageContent;
import org.jfree.report.content.ImageContentFactoryModule;
import org.jfree.report.content.ShapeContentFactoryModule;
import org.jfree.report.content.TextContentFactoryModule;
import org.jfree.report.layout.DefaultLayoutSupport;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.support.itext.BaseFontCreateException;
import org.jfree.report.modules.output.support.itext.BaseFontSupport;
import org.jfree.report.modules.output.support.itext.ITextImageCache;
import org.jfree.report.modules.output.table.base.RawContent;
import org.jfree.report.modules.output.table.base.TableMetaBandProducer;
import org.jfree.report.modules.output.table.rtf.metaelements.RTFImageMetaElement;
import org.jfree.report.modules.output.table.rtf.metaelements.RTFTextMetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.geom.StrictBounds;

public class RTFMetaBandProducer
extends TableMetaBandProducer {
    private BaseFontSupport baseFontSupport;
    private String encoding;
    private ITextImageCache imageCache;

    public RTFMetaBandProducer(String encoding, boolean useMaxLineHeight) {
        super(new DefaultLayoutSupport(RTFMetaBandProducer.createContentFactory(), useMaxLineHeight));
        if (encoding == null) {
            throw new NullPointerException("Encoding must be a non null value");
        }
        this.encoding = encoding;
        this.baseFontSupport = new BaseFontSupport();
        this.imageCache = new ITextImageCache();
    }

    private static ContentFactory createContentFactory() {
        DefaultContentFactory contentFactory = new DefaultContentFactory();
        contentFactory.addModule(new TextContentFactoryModule());
        contentFactory.addModule(new ShapeContentFactoryModule());
        contentFactory.addModule(new AnchorContentFactoryModule());
        if (RTFMetaBandProducer.isImageSupportEnabled()) {
            contentFactory.addModule(new ImageContentFactoryModule());
        }
        return contentFactory;
    }

    protected MetaElement createDrawableCell(Element e, long x, long y) {
        return null;
    }

    protected MetaElement createImageCell(Element e, long x, long y) {
        Object o = e.getValue();
        if (!(o instanceof ImageContainer)) {
            return null;
        }
        if (!RTFMetaBandProducer.isImageSupportEnabled()) {
            return null;
        }
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        if (rect.getWidth() == 0L || rect.getHeight() == 0L) {
            return null;
        }
        return new RTFImageMetaElement(new ImageContent((ImageContainer)o, rect), this.createStyleForImageElement(e, x, y), this.imageCache);
    }

    protected MetaElement createTextCell(Element e, long x, long y) throws ContentCreationException {
        Object o = e.getValue();
        if (!(o instanceof String)) {
            return null;
        }
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        FontDefinition def = e.getStyle().getFontDefinitionProperty();
        String encoding = (String)e.getStyle().getStyleProperty(ElementStyleSheet.FONTENCODING, this.encoding);
        try {
            BaseFont font = this.baseFontSupport.createBaseFont(def, encoding, false).getBaseFont();
            return new RTFTextMetaElement(new RawContent(rect, o), this.createStyleForTextElement(e, x, y), font);
        }
        catch (BaseFontCreateException e1) {
            throw new ContentCreationException("Unable to create font for text element.", (Exception)((Object)e1));
        }
    }

    private static boolean isImageSupportEnabled() {
        return JFreeReportBoot.getInstance().getExtendedConfig().getBoolProperty("org.jfree.report.modules.output.table.rtf.EnableImages");
    }
}

