/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.rtf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfWriter2;
import com.lowagie.text.rtf.table.RtfCell;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.print.PageFormat;
import java.io.OutputStream;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.GenericObjectTable;
import org.jfree.report.modules.output.table.base.SheetLayout;
import org.jfree.report.modules.output.table.base.SheetLayoutCollection;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.base.TableContentCreator;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.report.modules.output.table.rtf.metaelements.RTFMetaElement;
import org.jfree.report.util.NoCloseOutputStream;
import org.jfree.report.util.StrokeUtility;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class RTFContentCreator
extends TableContentCreator {
    private static final String CREATOR = String.valueOf(JFreeReport.getInfo().getName()) + " version " + JFreeReport.getInfo().getVersion();
    private boolean open;
    private Document document;
    private OutputStream outputStream;

    public RTFContentCreator(SheetLayoutCollection sheetLayoutCollection, OutputStream outputStream) {
        super(sheetLayoutCollection);
        this.outputStream = outputStream;
    }

    protected void handleBeginTable(ReportDefinition reportDefinition) {
    }

    protected void handleClose() {
        this.open = false;
        this.document.close();
    }

    protected void handleEndTable() throws ReportProcessingException {
        SheetLayout layout = this.getCurrentLayout();
        if (layout.isEmpty()) {
            return;
        }
        try {
            GenericObjectTable go = this.getBackend();
            int height = go.getRowCount();
            int width = Math.max(go.getColumnCount(), layout.getColumnCount());
            Table table = new Table(width, height);
            table.setAutoFillEmptyCells(false);
            float[] cellWidths = new float[width];
            int i = 0;
            while (i < width) {
                cellWidths[i] = layout.getCellWidth(i, i + 1);
                ++i;
            }
            table.setWidths(cellWidths);
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    TableCellBackground background;
                    MetaElement element = (MetaElement)go.getObject(y, x);
                    if (element == null) {
                        Cell cell = new Cell();
                        cell.setBorderWidth(0.0f);
                        background = layout.getElementAt(y, x);
                        if (background != null) {
                            this.setCellBackgroundStyle(cell, background);
                        }
                        table.addCell(cell, y, x);
                    } else {
                        TableRectangle rectangle = layout.getTableBounds(element, this.getLookupRectangle());
                        if (rectangle.isOrigin(x, y)) {
                            background = rectangle.getColumnSpan() == 1 && rectangle.getRowSpan() == 1 ? layout.getElementAt(y, x) : layout.getRegionBackground(rectangle);
                            RTFMetaElement cellData = (RTFMetaElement)element;
                            RtfCell cell = cellData.getCell();
                            cell.setBorderWidth(0.0f);
                            if (background != null) {
                                this.setCellBackgroundStyle((Cell)cell, background);
                            }
                            if (rectangle.getRowSpan() > 1) {
                                cell.setRowspan(rectangle.getRowSpan());
                            }
                            if (rectangle.getColumnSpan() > 1) {
                                cell.setColspan(rectangle.getColumnSpan());
                            }
                            table.addCell((Cell)cell, y, x);
                            x += rectangle.getColumnSpan() - 1;
                        }
                    }
                    ++x;
                }
                ++y;
            }
            try {
                this.document.add((Element)table);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (BadElementException be) {
            throw new ReportProcessingException("Failed!", (Exception)((Object)be));
        }
        catch (DocumentException be) {
            throw new ReportProcessingException("Failed!", (Exception)((Object)be));
        }
    }

    protected void handleOpen(ReportDefinition reportDefinition) {
        String sheetName;
        PageFormat pageFormat = reportDefinition.getPageDefinition().getPageFormat(0);
        float urx = (float)pageFormat.getWidth();
        float ury = (float)pageFormat.getHeight();
        float marginLeft = (float)pageFormat.getImageableX();
        float marginRight = (float)(pageFormat.getWidth() - pageFormat.getImageableWidth() - pageFormat.getImageableX());
        float marginTop = (float)pageFormat.getImageableY();
        float marginBottom = (float)(pageFormat.getHeight() - pageFormat.getImageableHeight() - pageFormat.getImageableY());
        Rectangle pageSize = new Rectangle(urx, ury);
        this.document = new Document(pageSize, marginLeft, marginRight, marginTop, marginBottom);
        RtfWriter2.getInstance((Document)this.document, (OutputStream)new NoCloseOutputStream(this.outputStream));
        String author = reportDefinition.getReportConfiguration().getConfigProperty("org.jfree.report.targets.table.rtf.Author");
        if (author != null) {
            this.document.addAuthor(author);
        }
        if (this.getSheetNameFunction() != null && (sheetName = String.valueOf(reportDefinition.getDataRow().get(this.getSheetNameFunction()))) != null) {
            this.document.addTitle(sheetName);
        }
        this.document.addProducer();
        this.document.addCreator(CREATOR);
        try {
            this.document.addCreationDate();
        }
        catch (Exception e) {
            Log.debug((Object)"Unable to add creation date. It will have to work without it.", (Exception)e);
        }
        this.document.open();
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    private void setCellBackgroundStyle(Cell cell, TableCellBackground bg) {
        if (bg == null) {
            return;
        }
        Color color = bg.getColor();
        if (color != null) {
            cell.setBackgroundColor(color);
        }
        Color bT = bg.getColorTop();
        Color bB = bg.getColorBottom();
        Color bL = bg.getColorLeft();
        Color bR = bg.getColorRight();
        if (bT == null || bB == null || bL == null || bR == null) {
            return;
        }
        if (bT.equals(bB) && bT.equals(bL) && bT.equals(bR) && ObjectUtilities.equal((Object)bg.getBorderStrokeTop(), (Object)bg.getBorderStrokeBottom()) && ObjectUtilities.equal((Object)bg.getBorderStrokeTop(), (Object)bg.getBorderStrokeLeft()) && ObjectUtilities.equal((Object)bg.getBorderStrokeTop(), (Object)bg.getBorderStrokeRight())) {
            Stroke s = bg.getBorderStrokeTop();
            float width = StrokeUtility.getStrokeWidth(s);
            cell.setBorderColor(bT);
            cell.setBorderWidth(width);
        }
    }
}

