/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html.metaelements;

import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.report.ImageContainer;
import org.jfree.report.content.ImageContent;
import org.jfree.report.modules.output.table.html.HtmlFilesystem;
import org.jfree.report.modules.output.table.html.metaelements.HtmlMetaElement;
import org.jfree.report.modules.output.table.html.ref.HtmlReference;
import org.jfree.report.modules.output.table.html.util.HtmlCharacterEntities;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.util.Log;

public class HtmlImageMetaElement
extends HtmlMetaElement {
    private boolean useDevIndependentImageSizes;

    public HtmlImageMetaElement(ImageContent elementContent, ElementStyleSheet style, boolean usesXHTML, boolean useDevIndependentImageSizes) {
        super(elementContent, style, usesXHTML);
        this.useDevIndependentImageSizes = useDevIndependentImageSizes;
    }

    public boolean isUseDevIndependentImageSizes() {
        return this.useDevIndependentImageSizes;
    }

    public void write(PrintWriter pout, HtmlFilesystem filesystem, boolean emptyCellsUseCSS) {
        ImageContent content = (ImageContent)this.getContent();
        try {
            ImageContainer image = content.getContent();
            HtmlReference href = filesystem.createImageReference(image);
            String referenceData = href.getReferenceData();
            if (href.isExternal()) {
                StrictBounds imageArea = content.getBounds();
                int imageWidth = (int)StrictGeomUtility.toExternalValue(imageArea.getWidth());
                int imageHeight = (int)StrictGeomUtility.toExternalValue(imageArea.getHeight());
                pout.print("<img src=\"");
                pout.print(referenceData);
                pout.print("\" style=\"width:");
                pout.write(String.valueOf(imageWidth));
                if (this.useDevIndependentImageSizes) {
                    pout.print("pt; height:");
                } else {
                    pout.print("px; height:");
                }
                pout.write(String.valueOf(imageHeight));
                if (this.useDevIndependentImageSizes) {
                    pout.print("pt;");
                } else {
                    pout.print("px;");
                }
                if (referenceData != null) {
                    pout.print("\" alt=\"");
                    pout.print(HtmlCharacterEntities.getEntityParser().encodeEntities(referenceData));
                }
                if (this.isUsesXHTML()) {
                    pout.print("\" />");
                } else {
                    pout.print("\" >");
                }
            } else if (!(emptyCellsUseCSS || referenceData != null && referenceData.trim().length() != 0)) {
                pout.print("&nbsp;");
            } else {
                pout.print(referenceData);
            }
        }
        catch (IOException ioe) {
            Log.warn((Object)"Writing the image failed", (Exception)ioe);
        }
    }
}

