/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import org.jfree.report.ReportDefinition;
import org.jfree.report.modules.output.meta.MetaBand;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.AbstractTableCreator;
import org.jfree.report.modules.output.table.base.LayoutCreator;
import org.jfree.report.modules.output.table.base.SheetLayout;
import org.jfree.report.modules.output.table.base.SheetLayoutCollection;

public class DefaultLayoutCreator
extends AbstractTableCreator
implements LayoutCreator {
    private boolean open;
    private SheetLayoutCollection sheetLayoutCollection;
    private SheetLayout currentSheet;
    private String configurationPrefix;

    public DefaultLayoutCreator(String configurationPrefix) {
        if (configurationPrefix == null) {
            throw new NullPointerException();
        }
        this.configurationPrefix = configurationPrefix;
    }

    public void beginTable(ReportDefinition report) {
        boolean strictLayout = report.getReportConfiguration().getConfigProperty(String.valueOf(this.configurationPrefix) + "." + "StrictLayout", "false").equals("true");
        this.setSheetLayout(this.createSheetLayout(strictLayout));
    }

    public void close() {
        this.open = false;
    }

    protected SheetLayout createSheetLayout(boolean strict) {
        return new SheetLayout(strict);
    }

    public void endTable() {
        this.currentSheet.pageCompleted();
        if (!this.currentSheet.isEmpty()) {
            this.sheetLayoutCollection.addLayout(this.currentSheet);
        }
        this.currentSheet = null;
    }

    public boolean flush() {
        return false;
    }

    protected SheetLayout getCurrentSheet() {
        return this.currentSheet;
    }

    public SheetLayoutCollection getSheetLayoutCollection() {
        return this.sheetLayoutCollection;
    }

    public boolean isEmpty() {
        if (this.currentSheet == null) {
            return true;
        }
        return this.currentSheet.isEmpty();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void open(ReportDefinition report) {
        this.open = true;
        boolean globalLayout = report.getReportConfiguration().getConfigProperty(String.valueOf(this.configurationPrefix) + "." + "GlobalLayout", "false").equals("true");
        this.sheetLayoutCollection = new SheetLayoutCollection(globalLayout);
    }

    protected boolean processBandDefinition(MetaBand e) {
        this.currentSheet.add(e);
        return false;
    }

    protected void processElement(MetaElement e) {
        this.currentSheet.add(e);
    }

    protected void setSheetLayout(SheetLayout sheetLayout) {
        this.currentSheet = sheetLayout;
    }
}

