/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.base.pagelayout;

import java.util.ArrayList;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.event.PageEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.modules.output.meta.MetaBand;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.meta.MetaPage;
import org.jfree.report.modules.output.pageable.base.LogicalPage;
import org.jfree.report.states.ReportState;
import org.jfree.util.Log;

public abstract class PageLayouter
extends AbstractFunction
implements PageEventListener {
    private LayoutManagerState layoutManagerState;
    private LogicalPage logicalPage;
    private ReportEvent currentEvent;
    private boolean pageEnded;
    private int depLevel;
    private boolean finishingPage;
    private boolean restartingPage;
    private boolean pageRestartDone;
    private boolean autoPageBreak;
    private ArrayList bands;

    public PageLayouter() {
        this.setDependencyLevel(-1);
        this.bands = new ArrayList(40);
    }

    protected void addRootMetaBand(MetaBand band) {
        if (band.getElementCount() > 0) {
            this.bands.add(band);
        }
    }

    protected void clearCurrentEvent() {
        if (this.currentEvent == null) {
            Log.error((Object)"Failed to clear current event; we don't have an event set!", (Exception)new IllegalStateException("stacktrace generated:"));
        }
        this.currentEvent = null;
    }

    public void clearLogicalPage() {
        this.logicalPage = null;
    }

    protected void clearSaveState() {
        this.layoutManagerState = null;
    }

    public Object clone() throws CloneNotSupportedException {
        PageLayouter l = (PageLayouter)super.clone();
        l.currentEvent = null;
        return l;
    }

    protected void endPage() throws ReportProcessingException {
        if (this.isRestartingPage()) {
            throw new ReportProcessingException("Report does not proceed (PageEnd during RestartPage)");
        }
        this.layoutManagerState = this.saveCurrentState();
        this.pageEnded = true;
    }

    public void finishPageAfterRestore(ReportState state) throws ReportProcessingException {
        try {
            this.setFinishingPage(true);
            ReportEvent cEvent = new ReportEvent(state, state.getEventCode() | 0x400);
            cEvent.getState().firePageFinishedEvent();
            cEvent.getState().nextPage();
            this.setCurrentEvent(cEvent);
            this.layoutManagerState = this.saveCurrentState();
        }
        finally {
            Object var3_3 = null;
            this.pageEnded = true;
            this.setFinishingPage(false);
            this.clearCurrentEvent();
        }
    }

    protected ReportEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public int getDependencyLevel() {
        return this.depLevel;
    }

    public LayoutManagerState getLayoutManagerState() {
        return this.layoutManagerState;
    }

    public LogicalPage getLogicalPage() {
        return this.logicalPage;
    }

    public MetaPage getMetaPage() {
        MetaBand[] bandArray = this.bands.toArray(new MetaBand[this.bands.size()]);
        MetaPage p = new MetaPage(bandArray);
        return p;
    }

    public ReportDefinition getReport() {
        if (this.getCurrentEvent() == null) {
            throw new IllegalStateException("No Current Event available.");
        }
        return this.getCurrentEvent().getReport();
    }

    public Object getValue() {
        return this;
    }

    public boolean isAutomaticPagebreak() {
        return this.autoPageBreak;
    }

    public boolean isFinishingPage() {
        return this.finishingPage;
    }

    public boolean isGeneratedPageEmpty() {
        MetaElement[] elements = this.bands.toArray(new MetaElement[this.bands.size()]);
        return MetaPage.isEmpty(elements);
    }

    public abstract boolean isNewPageStarted();

    public boolean isPageEnded() {
        return this.pageEnded;
    }

    public boolean isPageRestartDone() {
        return this.pageRestartDone;
    }

    public boolean isRestartingPage() {
        return this.restartingPage;
    }

    public void pageCanceled(ReportEvent event) {
    }

    public abstract void pageFinished(ReportEvent var1);

    public abstract void pageRolledBack(ReportEvent var1);

    public abstract void pageStarted(ReportEvent var1);

    public abstract void restartPage(ReportState var1) throws ReportProcessingException;

    public void restoreSaveState(ReportState ancestor) throws ReportProcessingException {
        LayoutManagerState state = this.getLayoutManagerState();
        this.pageEnded = false;
        this.autoPageBreak = false;
        this.setPageRestartDone(false);
        this.bands.clear();
        if (state == null && ancestor.getCurrentPage() != 0) {
            throw new IllegalStateException("State is null, but this is not the first page." + ancestor.getCurrentPage());
        }
    }

    protected abstract LayoutManagerState saveCurrentState();

    protected void setAutomaticPagebreak(boolean b) {
        this.autoPageBreak = b;
    }

    protected void setCurrentEvent(ReportEvent currentEvent) {
        if (currentEvent == null) {
            throw new NullPointerException("Event must not be null.");
        }
        this.currentEvent = currentEvent;
    }

    public void setDependencyLevel(int deplevel) {
        this.depLevel = deplevel;
    }

    public void setFinishingPage(boolean finishingPage) {
        this.finishingPage = finishingPage;
    }

    public void setLogicalPage(LogicalPage logicalPage) {
        if (logicalPage == null) {
            throw new NullPointerException("PageLayouter.setLogicalPage: logicalPage is null.");
        }
        this.logicalPage = logicalPage;
    }

    public void setPageRestartDone(boolean pageRestartDone) {
        this.pageRestartDone = pageRestartDone;
    }

    public void setRestartingPage(boolean restartingPage) {
        this.restartingPage = restartingPage;
    }

    protected void startPage(ReportState reportState) {
        if (this.isPageRestartDone()) {
            throw new IllegalStateException("Page already started");
        }
        if (reportState == null) {
            throw new NullPointerException("PageLayouter.startPage(...): state is null.");
        }
        this.setRestartingPage(true);
        reportState.firePageStartedEvent(reportState.getEventCode());
        this.setRestartingPage(false);
        this.setPageRestartDone(true);
    }

    protected static abstract class LayoutManagerState
    implements Cloneable {
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

