/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.base;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.report.EmptyReportException;
import org.jfree.report.JFreeReport;
import org.jfree.report.PageDefinition;
import org.jfree.report.ReportEventException;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.event.RepaginationListener;
import org.jfree.report.event.RepaginationState;
import org.jfree.report.modules.output.meta.MetaPage;
import org.jfree.report.modules.output.pageable.base.OutputTarget;
import org.jfree.report.modules.output.pageable.base.OutputTargetException;
import org.jfree.report.modules.output.pageable.base.PageProcess;
import org.jfree.report.modules.output.pageable.base.ReportStateList;
import org.jfree.report.modules.output.pageable.base.pagelayout.PageLayouter;
import org.jfree.report.states.FinishState;
import org.jfree.report.states.ReportState;
import org.jfree.report.states.ReportStateProgress;
import org.jfree.report.states.StartState;
import org.jfree.report.util.ReportConfigurationUtil;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class PageableReportProcessor {
    private static final int MAX_EVENTS_PER_RUN = 200;
    private static final int MIN_ROWS_PER_EVENT = 200;
    private static final int PRINT_FUNCTION_LEVEL = -1;
    public static final String LAYOUTMANAGER_NAME = "pageable.layoutManager";
    private JFreeReport report;
    private OutputTarget outputTarget;
    private boolean handleInterruptedState;
    private ArrayList listeners;
    private Object[] listenersCache;
    private ReportStateList stateList;
    static /* synthetic */ Class class$org$jfree$report$modules$output$pageable$base$pagelayout$SimplePageLayouter;

    public PageableReportProcessor(JFreeReport report) throws ReportProcessingException {
        try {
            JFreeReport internalReport = (JFreeReport)report.clone();
            String layouter = internalReport.getReportConfiguration().getConfigProperty(LAYOUTMANAGER_NAME);
            PageLayouter lm = this.createLayoutManager(layouter);
            internalReport.addExpression(lm);
            this.report = internalReport;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Initial Clone of Report failed");
        }
    }

    public void addRepaginationListener(RepaginationListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(5);
        }
        this.listenersCache = null;
        this.listeners.add(l);
    }

    private void checkInterrupted() throws ReportInterruptedException {
        if (this.isHandleInterruptedState() && Thread.interrupted()) {
            throw new ReportInterruptedException("Current thread is interrupted. Returning.");
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private PageLayouter createLayoutManager(String key) throws ReportProcessingException {
        if (key == null) {
            key = (class$org$jfree$report$modules$output$pageable$base$pagelayout$SimplePageLayouter != null ? class$org$jfree$report$modules$output$pageable$base$pagelayout$SimplePageLayouter : (class$org$jfree$report$modules$output$pageable$base$pagelayout$SimplePageLayouter = PageableReportProcessor.class$("org.jfree.report.modules.output.pageable.base.pagelayout.SimplePageLayouter"))).getName();
        }
        try {
            Class<?> c = this.getClass().getClassLoader().loadClass(key);
            PageLayouter lm = (PageLayouter)c.newInstance();
            lm.setName(LAYOUTMANAGER_NAME);
            return lm;
        }
        catch (Exception e) {
            throw new ReportProcessingException("Unable to create the layoutmanager", e);
        }
    }

    public PageProcess createPageProcess() {
        boolean failOnError = ReportConfigurationUtil.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
        JFreeReport report = this.getReport();
        return new PageProcess(this.getOutputTarget(), report.getPageDefinition(), failOnError);
    }

    protected void fireStateUpdate(RepaginationState state) {
        if (this.listeners == null) {
            return;
        }
        if (this.listenersCache == null) {
            this.listenersCache = this.listeners.toArray();
        }
        int i = 0;
        while (i < this.listenersCache.length) {
            RepaginationListener l = (RepaginationListener)this.listenersCache[i];
            l.repaginationUpdate(state);
            ++i;
        }
    }

    public synchronized OutputTarget getOutputTarget() {
        return this.outputTarget;
    }

    public synchronized int getPageCount() {
        if (!this.isPaginated()) {
            return 0;
        }
        return this.getReport().getPageDefinition().getPageCount() * this.stateList.size();
    }

    protected JFreeReport getReport() {
        return this.report;
    }

    protected synchronized ReportState getStateForPage(int page) throws ReportProcessingException {
        if (!this.isPaginated()) {
            throw new IllegalStateException("Report processor is not paginated.");
        }
        int pageCount = this.getReport().getPageDefinition().getPageCount();
        return this.stateList.get(page / pageCount);
    }

    protected boolean isEmptyPageGenerated(ReportState state) {
        PageLayouter org = (PageLayouter)state.getDataRow().get(LAYOUTMANAGER_NAME);
        return org.isGeneratedPageEmpty();
    }

    public boolean isHandleInterruptedState() {
        return this.handleInterruptedState;
    }

    public synchronized boolean isPaginated() {
        return this.stateList != null;
    }

    protected void performGenerate(MetaPage mp, int page) throws ReportProcessingException {
        PageDefinition physPage = this.getReport().getPageDefinition();
        OutputTarget output = this.getOutputTarget();
        try {
            output.printPage(mp, physPage, page);
        }
        catch (OutputTargetException e) {
            throw new ReportProcessingException("Failed to commit page " + page, (Exception)((Object)e));
        }
    }

    protected void performGenerateAll(MetaPage mp) throws ReportProcessingException {
        PageDefinition physPage = this.getReport().getPageDefinition();
        int i = 0;
        while (i < physPage.getPageCount()) {
            this.performGenerate(mp, i);
            ++i;
        }
    }

    private ReportStateList performRepaginate() throws ReportProcessingException {
        OutputTarget outputTarget = this.getOutputTarget();
        if (outputTarget == null) {
            throw new NullPointerException("No output target given.");
        }
        try {
            boolean hasNext;
            StartState startState = new StartState(this.getReport(), outputTarget.getExportDescription());
            ReportState state = startState;
            int maxRows = this.getReport().getData().getRowCount();
            outputTarget.configure((Configuration)this.getReport().getReportConfiguration());
            state.setProperty("report.preparerun", Boolean.TRUE);
            Iterator it = startState.getLevels();
            if (!it.hasNext()) {
                throw new IllegalStateException("No functions defined, invalid implementation.");
            }
            ReportStateList pageStates = null;
            int level = (Integer)it.next();
            do {
                if (level == -1) {
                    pageStates = new ReportStateList(this.createPageProcess());
                    state = this.processPrintedPages(state, pageStates, maxRows);
                } else {
                    state = this.processPrepareLevels(state, level, maxRows);
                }
                hasNext = it.hasNext();
                if (!hasNext) continue;
                level = (Integer)it.next();
                if (state instanceof FinishState) {
                    if ((state = new StartState((FinishState)state, level)).getCurrentPage() == 0) continue;
                    throw new IllegalStateException("State was not set up properly");
                }
                throw new IllegalStateException("Repaginate did not produce an finish state");
            } while (hasNext);
            state.setProperty("report.preparerun", Boolean.FALSE);
            return pageStates;
        }
        catch (CloneNotSupportedException cne) {
            throw new ReportProcessingException("Unable to initialize the report, clone error", cne);
        }
    }

    public void processPage(PageProcess pageProcess, int page, boolean failOnError) throws ReportProcessingException {
        ReportState pageState = this.getStateForPage(page);
        pageProcess.processPage(pageState, failOnError);
        int pageCount = this.getReport().getPageDefinition().getPageCount();
        this.performGenerate(pageProcess.getMetaPage(), page % pageCount);
    }

    private ReportState processPrepareLevels(ReportState state, int level, int maxRows) throws ReportProcessingException {
        boolean failOnError = ReportConfigurationUtil.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
        ReportStateProgress progress = null;
        int lastRow = -1;
        int eventCount = 0;
        int eventTrigger = Math.min(maxRows / 200, 200);
        RepaginationState repaginationState = new RepaginationState(this, 0, 0, 0, 0, true);
        while (!state.isFinish()) {
            this.checkInterrupted();
            if (lastRow != state.getCurrentDisplayItem()) {
                lastRow = state.getCurrentDisplayItem();
                if (eventCount == 0) {
                    repaginationState.reuse(level, state.getCurrentPage(), state.getCurrentDataItem(), maxRows, true);
                    this.fireStateUpdate(repaginationState);
                    ++eventCount;
                } else {
                    eventCount = eventCount == eventTrigger ? 0 : ++eventCount;
                }
            }
            progress = state.createStateProgress(progress);
            state = state.advance();
            if (failOnError) {
                if (state.isErrorOccured()) {
                    throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
                }
            } else if (state.isErrorOccured()) {
                Log.error((Object)"Failed to dispatch an event.", (Exception)((Object)new ReportEventException("Failed to dispatch an event.", state.getErrors())));
            }
            if (state.isFinish() || state.isProceeding(progress)) continue;
            throw new ReportProcessingException("State did not proceed, bailing out!");
        }
        return state;
    }

    private ReportState processPrintedPages(ReportState state, ReportStateList pageStates, int maxRows) throws ReportProcessingException {
        boolean failOnError = ReportConfigurationUtil.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
        ReportStateProgress progress = null;
        RepaginationState repaginationState = new RepaginationState(this, 0, 0, 0, 0, true);
        PageProcess process = this.createPageProcess();
        while (!state.isFinish()) {
            repaginationState.reuse(-1, state.getCurrentPage(), state.getCurrentDataItem(), maxRows, false);
            this.fireStateUpdate(repaginationState);
            ReportState oldstate = state;
            progress = state.createStateProgress(progress);
            state = process.processPage(state, failOnError);
            if (!state.isFinish() && !state.isProceeding(progress)) {
                throw new ReportProcessingException("State did not proceed, bailing out!");
            }
            if (!this.isEmptyPageGenerated(state)) {
                pageStates.add(oldstate);
                continue;
            }
            state.firePageCanceledEvent();
        }
        return state;
    }

    public synchronized void processReport() throws ReportProcessingException, EmptyReportException {
        OutputTarget outputTarget = this.getOutputTarget();
        if (outputTarget == null) {
            throw new NullPointerException("No output target given.");
        }
        if (!this.isPaginated()) {
            this.repaginate();
        }
        if (!outputTarget.isOpen()) {
            throw new ReportProcessingException("Given output target is not open.");
        }
        ReportStateList list = this.stateList;
        if (list.size() == 0) {
            throw new EmptyReportException("EmptyReport: Repaginating returned no pages");
        }
        boolean failOnError = ReportConfigurationUtil.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
        RepaginationState repaginationState = new RepaginationState(this, 0, 0, 0, 0, false);
        int pageCount = this.getReport().getPageDefinition().getPageCount();
        PageProcess pageProcess = this.createPageProcess();
        int i = 0;
        while (i < list.size()) {
            ReportState rs = list.get(i);
            repaginationState.reuse(-1, rs.getCurrentPage(), rs.getCurrentDataItem(), rs.getNumberOfRows(), false);
            this.fireStateUpdate(repaginationState);
            pageProcess.processPage(rs, failOnError);
            MetaPage mp = pageProcess.getMetaPage();
            int p = 0;
            while (p < pageCount) {
                this.performGenerate(mp, p);
                ++p;
            }
            ++i;
        }
    }

    public void removeRepaginationListener(RepaginationListener l) {
        if (l == null) {
            throw new NullPointerException("Listener == null");
        }
        if (this.listeners == null) {
            return;
        }
        this.listenersCache = null;
        ((AbstractCollection)this.listeners).remove(l);
    }

    public synchronized void repaginate() throws ReportProcessingException {
        this.stateList = this.performRepaginate();
    }

    public synchronized void resetPagination() {
        this.stateList = null;
    }

    public void setHandleInterruptedState(boolean handleInterruptedState) {
        this.handleInterruptedState = handleInterruptedState;
    }

    public synchronized void setOutputTarget(OutputTarget outputTarget) {
        this.outputTarget = outputTarget;
        this.report.setProperty("report.layout-support", outputTarget);
    }
}

