/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config.editor;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.modules.Module;
import org.jfree.report.modules.gui.config.editor.DefaultModuleEditor;
import org.jfree.report.modules.gui.config.editor.ModuleEditor;
import org.jfree.report.modules.gui.config.model.ConfigDescriptionEntry;

public final class EditorFactory {
    private static EditorFactory factory;
    private final Hashtable priorities = new Hashtable();

    private EditorFactory() {
        this.registerModuleEditor(new DefaultModuleEditor(), -1);
    }

    public static synchronized EditorFactory getInstance() {
        if (factory == null) {
            factory = new EditorFactory();
        }
        return factory;
    }

    public ModuleEditor getModule(Module module, HierarchicalConfiguration config, ConfigDescriptionEntry[] keyNames) {
        if (module == null) {
            throw new NullPointerException("Module is null.");
        }
        if (config == null) {
            throw new NullPointerException("config is null.");
        }
        if (keyNames == null) {
            throw new NullPointerException("keyNames is null.");
        }
        Enumeration keys = this.priorities.keys();
        ModuleEditor currentEditor = null;
        int currentEditorPriority = Integer.MIN_VALUE;
        while (keys.hasMoreElements()) {
            Integer prio;
            ModuleEditor ed = (ModuleEditor)keys.nextElement();
            if (!ed.canHandle(module) || (prio = (Integer)this.priorities.get(ed)) <= currentEditorPriority) continue;
            currentEditorPriority = prio;
            currentEditor = ed;
        }
        if (currentEditor != null) {
            return currentEditor.createInstance(module, config, keyNames);
        }
        return null;
    }

    public void registerModuleEditor(ModuleEditor editor, int priority) {
        if (editor == null) {
            throw new NullPointerException("Editor is null.");
        }
        this.priorities.put(editor, new Integer(priority));
    }
}

