/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function.strings;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.report.function.AbstractExpression;

public class MapIndirectExpression
extends AbstractExpression {
    private String field;
    private ArrayList keys = new ArrayList();
    private ArrayList forwards = new ArrayList();
    private boolean ignoreCase;
    private String fallbackForward;
    private String nullValue;

    public Object clone() throws CloneNotSupportedException {
        MapIndirectExpression co = (MapIndirectExpression)super.clone();
        co.forwards = (ArrayList)this.forwards.clone();
        co.keys = (ArrayList)this.keys.clone();
        return co;
    }

    public String getFallbackForward() {
        return this.fallbackForward;
    }

    public String getField() {
        return this.field;
    }

    public String[] getForward() {
        return this.forwards.toArray(new String[this.forwards.size()]);
    }

    public String getForward(int index) {
        return (String)this.forwards.get(index);
    }

    public int getForwardCount() {
        return this.forwards.size();
    }

    public String[] getKey() {
        return this.keys.toArray(new String[this.keys.size()]);
    }

    public String getKey(int index) {
        return (String)this.keys.get(index);
    }

    public int getKeyCount() {
        return this.keys.size();
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public Object getValue() {
        Object raw = this.getDataRow().get(this.getField());
        if (raw == null) {
            return this.getNullValue();
        }
        String text = String.valueOf(raw);
        int length = Math.min(this.keys.size(), this.forwards.size());
        int i = 0;
        while (i < length) {
            String key = (String)this.keys.get(i);
            if (this.isIgnoreCase()) {
                if (text.equalsIgnoreCase(key)) {
                    String target = (String)this.forwards.get(i);
                    return this.getDataRow().get(target);
                }
            } else if (text.equals(key)) {
                String target = (String)this.forwards.get(i);
                return this.getDataRow().get(target);
            }
            ++i;
        }
        String fallbackValue = this.getFallbackForward();
        if (fallbackValue != null) {
            return this.getDataRow().get(fallbackValue);
        }
        return raw;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setFallbackForward(String fallbackForward) {
        this.fallbackForward = fallbackForward;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setForward(int index, String value) {
        if (this.forwards.size() == index) {
            this.forwards.add(value);
        } else {
            this.forwards.set(index, value);
        }
    }

    public void setForward(String[] expression) {
        this.forwards.clear();
        this.forwards.addAll(Arrays.asList(expression));
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setKey(int index, String key) {
        if (this.keys.size() == index) {
            this.keys.add(key);
        } else {
            this.keys.set(index, key);
        }
    }

    public void setKey(String[] keys) {
        this.keys.clear();
        this.keys.addAll(Arrays.asList(keys));
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }
}

