/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import org.jfree.report.Group;
import org.jfree.report.ReportDefinition;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;

public class HidePageBandForTableExportFunction
extends AbstractFunction {
    private boolean hidePageBands = true;
    private boolean disableRepeatingHeader;

    public Object getValue() {
        return null;
    }

    public boolean isDisableRepeatingHeader() {
        return this.disableRepeatingHeader;
    }

    public boolean isHidePageBands() {
        return this.hidePageBands;
    }

    public void reportInitialized(ReportEvent event) {
        boolean isTable = this.getRuntime().getExportDescriptor().startsWith("table");
        ReportDefinition report = event.getReport();
        if (this.isHidePageBands()) {
            report.getPageHeader().setVisible(!isTable);
            report.getPageFooter().setVisible(!isTable);
        }
        if (this.isDisableRepeatingHeader()) {
            int gc = report.getGroupCount();
            int i = 0;
            while (i < gc) {
                Group g = report.getGroup(i);
                if (g.getHeader().isRepeat()) {
                    g.getHeader().setRepeat(!isTable);
                }
                ++i;
            }
        }
    }

    public void setDisableRepeatingHeader(boolean disableRepeatingHeader) {
        this.disableRepeatingHeader = disableRepeatingHeader;
    }

    public void setHidePageBands(boolean hidePageBands) {
        this.hidePageBands = hidePageBands;
    }
}

