/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import org.jfree.report.DefaultImageReference;
import org.jfree.report.filter.DataFilter;
import org.jfree.report.filter.DataSource;
import org.jfree.report.util.KeyedQueue;
import org.jfree.util.Log;

public class ImageLoadFilter
implements DataFilter,
Serializable {
    private transient KeyedQueue imageCache;
    private DataSource source;

    public ImageLoadFilter() {
        this(10);
    }

    public ImageLoadFilter(int cacheSize) {
        this.imageCache = new KeyedQueue(cacheSize);
    }

    public Object clone() throws CloneNotSupportedException {
        ImageLoadFilter il = (ImageLoadFilter)super.clone();
        il.imageCache = (KeyedQueue)this.imageCache.clone();
        if (this.source != null) {
            il.source = (DataSource)this.source.clone();
        }
        return il;
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public Object getValue() {
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return null;
        }
        Object o = ds.getValue();
        if (o == null) {
            return null;
        }
        if (!(o instanceof URL)) {
            return null;
        }
        URL url = (URL)o;
        Object retval = this.imageCache.get(url);
        if (retval == null) {
            try {
                retval = new DefaultImageReference(url);
            }
            catch (IOException ioe) {
                Log.warn((Object)("Error while loading the image from " + url), (Exception)ioe);
                return null;
            }
        }
        this.imageCache.put(url, retval);
        return retval;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int limit = in.readInt();
        this.imageCache = new KeyedQueue(limit);
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.source = ds;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.imageCache.getLimit());
    }
}

