/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.TextElementFactory;
import org.jfree.report.filter.templates.ResourceMessageTemplate;
import org.jfree.report.style.FontDefinition;
import org.jfree.ui.FloatDimension;

public class ResourceMessageElementFactory
extends TextElementFactory {
    private String resourceBase;
    private String nullString;
    private String formatKey;

    public Element createElement() {
        if (this.getFormatKey() == null) {
            throw new IllegalStateException("ResourceKey is not set.");
        }
        ResourceMessageTemplate template = new ResourceMessageTemplate();
        template.setResourceIdentifier(this.getResourceBase());
        template.setFormatKey(this.getFormatKey());
        template.setNullValue(this.getNullString());
        TextElement element = new TextElement();
        this.applyElementName(element);
        element.setDataSource(template);
        this.applyStyle(element.getStyle());
        return element;
    }

    public static TextElement createResourceLabel(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullValue, String resourceBase, String resourceKey) {
        ResourceMessageElementFactory factory = new ResourceMessageElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setNullString(nullValue);
        factory.setResourceBase(resourceBase);
        factory.setFormatKey(resourceKey);
        return (TextElement)factory.createElement();
    }

    public String getFormatKey() {
        return this.formatKey;
    }

    public String getNullString() {
        return this.nullString;
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setFormatKey(String formatKey) {
        this.formatKey = formatKey;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }
}

