/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import org.jfree.report.Element;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.ContentFactoryModule;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.content.TextContent;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.layout.SizeCalculatorException;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.report.util.geom.StrictPoint;

public class TextContentFactoryModule
implements ContentFactoryModule {
    public boolean canHandleContent(String contentType) {
        return contentType.equalsIgnoreCase("text/plain");
    }

    public Content createContentForElement(Element e, ElementLayoutInformation bounds, LayoutSupport ot) throws ContentCreationException {
        StrictDimension dim;
        Object value = e.getValue();
        if (value == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        String text = String.valueOf(value);
        if (text.length() == 0) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictPoint point = bounds.getAbsolutePosition();
        StrictDimension prefSize = bounds.getPreferredSize();
        long width = bounds.getMinimumSize().getWidth();
        long height = bounds.getMaximumSize().getHeight();
        if (prefSize != null) {
            width = Math.max(prefSize.getWidth(), width);
            height = Math.min(prefSize.getHeight(), height);
        }
        if ((dim = new StrictDimension(width, height)).getWidth() == 0L && dim.getHeight() == 0L) {
            return EmptyContent.getDefaultEmptyContent();
        }
        FontDefinition f = e.getStyle().getFontDefinitionProperty();
        StrictBounds tBounds = new StrictBounds(point.getX(), point.getY(), dim.getWidth(), dim.getHeight());
        Float lineHeight = (Float)e.getStyle().getStyleProperty(ElementStyleSheet.LINEHEIGHT);
        try {
            String reservedLiteral = (String)e.getStyle().getStyleProperty(ElementStyleSheet.RESERVED_LITERAL, "..");
            boolean trimTextContent = e.getStyle().getBooleanStyleProperty(ElementStyleSheet.TRIM_TEXT_CONTENT);
            TextContent tc = new TextContent(text, StrictGeomUtility.toInternalValue(lineHeight.floatValue()), tBounds, ot.createTextSizeCalculator(f), reservedLiteral, trimTextContent);
            return tc;
        }
        catch (SizeCalculatorException se) {
            throw new ContentCreationException("Failed to create the TextSizeCalculator", (Exception)((Object)se));
        }
    }
}

