/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import org.jfree.report.Anchor;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentType;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictPoint;

public class AnchorContent
implements Content {
    private Anchor ancor;
    private StrictPoint point;

    public AnchorContent(Anchor ancor, StrictPoint point) {
        if (ancor == null) {
            throw new NullPointerException("Anchor must not be null.");
        }
        if (point == null) {
            throw new NullPointerException("Position must not be null");
        }
        this.ancor = ancor;
        this.point = (StrictPoint)point.clone();
    }

    public Anchor getAnchor() {
        return this.ancor;
    }

    public StrictBounds getBounds() {
        return new StrictBounds(this.point.getX(), this.point.getY(), 1L, 1L);
    }

    public Content getContentForBounds(StrictBounds bounds) {
        if (bounds.contains(this.point.getX(), this.point.getY())) {
            return this;
        }
        return null;
    }

    public ContentType getContentType() {
        return ContentType.ANCHOR;
    }

    public StrictBounds getMinimumContentSize() {
        return this.getBounds();
    }

    public void translate(long x, long y) {
        this.point.setLocation(x + this.point.getX(), y + this.point.getY());
    }
}

