/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.joone.engine.Pattern;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.AbstractConverterPlugIn;
import org.joone.util.OutputPluginListener;

public abstract class OutputConverterPlugIn
extends AbstractConverterPlugIn {
    private transient Pattern conv_pattern;
    private static final long serialVersionUID = 1698511686417967414L;
    private static final ILogger log = LoggerFactory.getLogger(OutputConverterPlugIn.class);

    public OutputConverterPlugIn() {
    }

    public OutputConverterPlugIn(String anAdvancedSerieSelector) {
        super(anAdvancedSerieSelector);
    }

    protected abstract void convert_pattern(int var1);

    public void convertPattern() throws NumberFormatException {
        if (this.getAdvancedSerieSelector() != null && !this.getAdvancedSerieSelector().equals(new String(""))) {
            try {
                int[] mySerieSelected = this.getSerieSelected();
                for (int i = 0; i < mySerieSelected.length; ++i) {
                    this.convert_pattern(mySerieSelected[i] - 1);
                }
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException(nfe.getMessage());
            }
        } else {
            log.warn(this.getName() + " : Advanced Serie Selector not populated therefore converting no data.");
        }
        if (this.getNextPlugIn() != null) {
            OutputConverterPlugIn myPlugIn = (OutputConverterPlugIn)this.getNextPlugIn();
            myPlugIn.setPattern(this.getPattern());
            myPlugIn.convertPattern();
        }
    }

    public void convertAllPatterns() throws NumberFormatException {
        this.convertPatterns();
    }

    protected Pattern getPattern() {
        return this.conv_pattern;
    }

    public void setPattern(Pattern newPattern) {
        this.conv_pattern = newPattern;
    }

    public synchronized void addOutputPluginListener(OutputPluginListener aListener) {
        this.addPlugInListener(aListener);
    }

    public synchronized void removeOutputPluginListener(OutputPluginListener aListener) {
        this.removePlugInListener(aListener);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.getAdvancedSerieSelector() == null) {
            this.setAdvancedSerieSelector(new String("1"));
        }
        if (this.getName() == null) {
            this.setName("OutputPlugin 9");
        }
    }
}

