/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.io.Serializable;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NeuralNet;

public abstract class MonitorPlugin
implements Serializable,
NeuralNetListener {
    private String name;
    private static final long serialVersionUID = 951079164859904152L;
    private int rate = 1;
    private NeuralNet neuralNet;

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        if (this.toBeManaged(mon)) {
            this.manageCycle(mon);
        }
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        this.manageStop(mon);
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        this.manageStart(mon);
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        if (this.toBeManaged(mon)) {
            this.manageError(mon);
        }
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
        Monitor mon = (Monitor)e.getSource();
        this.manageStopError(mon, error);
    }

    protected boolean toBeManaged(Monitor monitor) {
        if (this.getRate() == 0) {
            return false;
        }
        int currentCycle = monitor.getTotCicles() - monitor.getCurrentCicle() + 1;
        int cl = currentCycle / this.getRate();
        return cl * this.getRate() == currentCycle;
    }

    protected abstract void manageStop(Monitor var1);

    protected abstract void manageCycle(Monitor var1);

    protected abstract void manageStart(Monitor var1);

    protected abstract void manageError(Monitor var1);

    protected abstract void manageStopError(Monitor var1, String var2);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRate() {
        return this.rate;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public NeuralNet getNeuralNet() {
        return this.neuralNet;
    }

    public void setNeuralNet(NeuralNet neuralNet) {
        this.neuralNet = neuralNet;
    }
}

