/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.TreeSet;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NetCheck;
import org.joone.net.NeuralNet;

public class XORTrainer
implements NeuralNetListener {
    private static String xorNet = "org/joone/samples/engine/xor/xor.snet";

    public static void main(String[] args) {
        XORTrainer xor = new XORTrainer();
        xor.Go(xorNet);
    }

    private void Go(String fileName) {
        NeuralNet xor = this.restoreNeuralNet(fileName);
        if (xor != null) {
            xor.getMonitor().addNeuralNetListener(this);
            xor.getMonitor().setLearning(true);
            TreeSet tree = xor.check();
            if (tree.isEmpty()) {
                xor.go(true);
                System.out.println("Network stopped. Last RMSE=" + xor.getMonitor().getGlobalError());
            } else {
                for (NetCheck nc : tree) {
                    System.out.println(nc.toString());
                }
            }
        }
    }

    private NeuralNet restoreNeuralNet(String fileName) {
        NeuralNet nnet = null;
        try {
            FileInputStream stream = new FileInputStream(fileName);
            ObjectInputStream input = new ObjectInputStream(stream);
            nnet = (NeuralNet)input.readObject();
        }
        catch (Exception e) {
            System.out.println("Exception was thrown. Message is : " + e.getMessage());
        }
        return nnet;
    }

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        long c = mon.getCurrentCicle();
        if (c % 200L == 0L) {
            System.out.println(c + " epochs remaining - RMSE = " + mon.getGlobalError());
        }
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
        System.out.println("Started...");
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
        System.out.println("Stopped...");
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
        System.out.println("Error: " + error);
        System.exit(1);
    }
}

