/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.editor.som;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import org.joone.samples.editor.som.ImageDrawer;

public class ImagePainter
extends ImageDrawer {
    private Color drawColor = new Color(0);
    private BufferedImage ImageToEdit = null;

    public ImagePainter() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ImagePainter.this.paintPixel(e.getX(), e.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ImagePainter.this.paintPixel(e.getX(), e.getY());
            }
        });
    }

    public void setDrawColor(Color newColor) {
        this.drawColor = newColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void paintPixel(int x, int y) {
        if (x < this.getImageToDraw().getWidth(this) && x >= 0 && y < this.getImageToDraw().getHeight(this) && y >= 0) {
            this.getImageToEdit().setRGB(x, y, this.getDrawColor().getRGB());
            this.repaint(0, 0, this.getImageToDraw().getWidth(this), this.getImageToDraw().getHeight(this));
        }
    }

    public BufferedImage getImageToEdit() {
        return this.ImageToEdit;
    }

    public void setImageToEdit(BufferedImage ImageToEdit) {
        this.ImageToEdit = ImageToEdit;
        this.setImageToDraw(ImageToEdit);
    }
}

