/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import org.joone.io.PatternTokenizer;

public class MemoryInputTokenizer
implements PatternTokenizer {
    private double[][] inputArray;
    private int lineNo = 0;
    private int mark = 0;
    private char decimalPoint;

    public MemoryInputTokenizer() {
    }

    public MemoryInputTokenizer(double[][] array) {
        this.inputArray = array;
    }

    @Override
    public void resetInput() throws IOException {
        this.lineNo = this.mark;
    }

    @Override
    public int getLineno() {
        return this.lineNo;
    }

    @Override
    public char getDecimalPoint() {
        return this.decimalPoint;
    }

    @Override
    public boolean nextLine() throws IOException {
        ++this.lineNo;
        return this.lineNo <= this.inputArray.length;
    }

    @Override
    public int getNumTokens() throws IOException {
        double[] line = this.getTokensArray();
        return line.length;
    }

    @Override
    public void mark() throws IOException {
        this.mark = this.lineNo;
    }

    @Override
    public double getTokenAt(int posiz) throws IOException {
        double[] line = this.getTokensArray();
        return line[posiz];
    }

    @Override
    public double[] getTokensArray() {
        return this.inputArray[this.lineNo - 1];
    }

    @Override
    public void setDecimalPoint(char decimalPoint) {
        this.decimalPoint = decimalPoint;
    }
}

