/*
 * Decompiled with CFR 0.152.
 */
package org.joone.helpers.templating;

import java.io.StringWriter;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.joone.helpers.structure.NeuralNetMatrix;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetLoader;

public class CodeGenerator {
    VelocityContext context = null;

    public CodeGenerator() throws Exception {
        this.context = this.init();
    }

    public CodeGenerator(Properties props) throws Exception {
        this.context = this.init(props);
    }

    public static void main(String[] args) throws Exception {
        CodeGenerator me = new CodeGenerator();
        NeuralNetLoader loader = new NeuralNetLoader("xor.snet");
        NeuralNet nnet = loader.getNeuralNet();
        String code = me.getCode(nnet, "codeTemplate.vm", "org.joone.test.templating", "TestClass");
        System.out.println(code);
    }

    protected VelocityContext init() throws Exception {
        Properties props = new Properties();
        props.setProperty("resource.loader", "file, class");
        props.setProperty("file.resource.loader.description", "Velocity File Resource Loader");
        props.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        props.setProperty("file.resource.loader.path", ".");
        props.setProperty("file.resource.loader.cache", "false");
        props.setProperty("file.resource.loader.modificationCheckInterval", "0");
        props.setProperty("class.resource.loader.description", "Velocity Classpath Resource Loader");
        props.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        return this.init(props);
    }

    protected VelocityContext init(Properties props) throws Exception {
        Velocity.init(props);
        return new VelocityContext();
    }

    public String getCode(NeuralNet nnet, String templateName, String packageName, String className) {
        StringWriter sw = new StringWriter();
        try {
            NeuralNetMatrix nMatrix = new NeuralNetMatrix(nnet.cloneNet());
            this.context.put("netDescriptor", nMatrix);
            this.context.put("package", packageName);
            this.context.put("class", className);
            Template template = null;
            try {
                template = Velocity.getTemplate(templateName);
                template.merge(this.context, sw);
            }
            catch (ResourceNotFoundException rnfe) {
                String message = "couldn't find the template";
                throw new Exception(message, rnfe);
            }
            catch (ParseErrorException pee) {
                String message = "syntax error : problem parsing the template";
                throw new Exception(message, pee);
            }
            catch (MethodInvocationException mie) {
                String message = "Exception threw in the template code";
                throw new Exception(message, mie);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return sw.toString().trim();
    }
}

