/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.TreeSet;
import org.joone.engine.FullSynapse;
import org.joone.engine.Learner;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;

public class KohonenSynapse
extends FullSynapse
implements NeuralNetListener {
    private static final long serialVersionUID = -4966435217407942471L;
    double currentLearningRate = 1.0;
    private double timeConstant = 200.0;
    private int orderingPhase = 1000;

    public KohonenSynapse() {
        this.learnable = false;
    }

    @Override
    protected void backward(double[] pattern) {
        double dFalloff = 0.0;
        int num_outs = this.getOutputDimension();
        double[] o_pattern = this.b_pattern.getOutArray();
        for (int x = 0; x < num_outs; ++x) {
            dFalloff = o_pattern[x];
            this.adjustNodeWeight(x, this.currentLearningRate, dFalloff, this.inps);
        }
    }

    @Override
    protected void forward(double[] pattern) {
        double temp = 0.0;
        double curDist = 0.0;
        int num_outs = this.getOutputDimension();
        for (int x = 0; x < num_outs; ++x) {
            curDist = 0.0;
            for (int inputs = 0; inputs < pattern.length; ++inputs) {
                temp = this.array.value[inputs][x] - pattern[inputs];
                temp *= temp;
                curDist += temp;
            }
            this.outs[x] = curDist;
        }
    }

    private void adjustNodeWeight(int curnode, double learningRate, double distanceFalloff, double[] pattern) {
        int output = curnode;
        for (int w = 0; w < this.getInputDimension(); ++w) {
            double wt = this.array.value[w][output];
            double vw = pattern[w];
            wt += distanceFalloff * learningRate * (vw - wt);
            this.array.value[w][output] = wt;
        }
    }

    @Override
    public void setMonitor(Monitor newMonitor) {
        super.setMonitor(newMonitor);
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(this, false);
        }
    }

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
        int currentCycle = this.getMonitor().getTotCicles() - this.getMonitor().getCurrentCicle();
        this.currentLearningRate = currentCycle < this.getOrderingPhase() ? this.getMonitor().getLearningRate() * Math.exp(-((double)currentCycle / this.getTimeConstant())) : 0.01;
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
        this.currentLearningRate = this.getMonitor().getLearningRate();
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
    }

    @Override
    public TreeSet check() {
        TreeSet checks = super.check();
        return checks;
    }

    public int getOrderingPhase() {
        return this.orderingPhase;
    }

    public void setOrderingPhase(int orderingPhase) {
        this.orderingPhase = orderingPhase;
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    public void setTimeConstant(double timeConstant) {
        this.timeConstant = timeConstant;
    }

    @Override
    public Learner getLearner() {
        this.learnable = false;
        return super.getLearner();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(this, false);
        }
    }
}

