/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit.visad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.joone.edit.ChartInterface;
import org.joone.edit.ChartingHandle;
import org.joone.edit.SharedBuffer;
import org.joone.engine.Monitor;
import org.joone.engine.NetErrorManager;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.Pattern;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.NotSerialize;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.util.GMCWidget;
import visad.util.RangeWidget;

public class VisADOutputSynapse
implements NotSerialize,
Serializable,
NeuralNetListener,
ChartInterface {
    private static final long serialVersionUID = 7501932794591309201L;
    private static final ILogger log = LoggerFactory.getLogger(VisADOutputSynapse.class);
    private boolean show;
    private Monitor monitor;
    private String name = "";
    private String title = "VisAD Chart";
    private boolean resizable = true;
    private int maxXaxis = 1000;
    private double maxYaxis = 1.0;
    private int serie = 1;
    private boolean outputFull;
    private transient JFrame iFrame;
    private boolean enabled = true;
    private transient ChartingHandle def_handle = new ChartingHandle();
    private transient JLabel status_label = new JLabel("Waiting for network to run!");
    private transient JPanel pane;
    private transient JPanel ControlPane = new JPanel();
    private transient Hashtable ChartBuffers = new Hashtable();
    private transient Hashtable DataRefs = new Hashtable();
    private transient Hashtable DataColors = new Hashtable();
    private transient Hashtable flat_fields = new Hashtable();
    private transient RealType time;
    private transient RealType height;
    private transient FunctionType func_time_height;
    private transient Set time_set;
    private transient FlatField vals_ff;
    private transient DataReferenceImpl data_ref;
    private transient DisplayImplJ2D display;
    private transient GMCWidget control_widg;
    private transient ScalarMap timeMap;
    private transient ScalarMap heightMap;
    private transient RangeWidget timeWidget;
    private transient RangeWidget heightWidget;
    private transient boolean visadinit = false;
    private transient int current_sample_index = 0;

    private void initVisAd(int max_samples, String msg) {
        block8: {
            try {
                if (this.getMonitor() != null) {
                    this.getMonitor().addNeuralNetListener(this);
                }
                this.status_label.setText(msg);
                this.time = RealType.getRealType((String)"Sample");
                this.height = RealType.getRealType((String)"Value");
                this.func_time_height = new FunctionType((MathType)this.time, (MathType)this.height);
                this.time_set = new Integer1DSet((MathType)this.time, max_samples);
                this.display = new DisplayImplJ2D("display1");
                this.display.setAutoAspect(true);
                GraphicsModeControl dispGMC = this.display.getGraphicsModeControl();
                this.control_widg = new GMCWidget(dispGMC);
                dispGMC.setScaleEnable(true);
                this.timeMap = new ScalarMap((ScalarType)this.time, Display.XAxis);
                this.heightMap = new ScalarMap((ScalarType)this.height, Display.YAxis);
                this.display.addMap(this.timeMap);
                this.display.addMap(this.heightMap);
                this.timeMap.setRange(0.0, (double)this.maxXaxis);
                this.heightMap.setRange(0.0, this.maxYaxis);
                this.timeWidget = new RangeWidget(this.timeMap);
                this.heightWidget = new RangeWidget(this.heightMap);
                if (this.iFrame != null) {
                    this.iFrame.getContentPane().removeAll();
                    this.pane = new JPanel();
                    this.ControlPane = new JPanel();
                    this.pane.setLayout(new BoxLayout(this.pane, 1));
                    this.pane.setAlignmentY(0.0f);
                    this.pane.setAlignmentX(0.0f);
                    this.pane.add(this.display.getComponent());
                    ((JPanel)this.display.getComponent()).setMinimumSize(new Dimension(500, 250));
                    ((JPanel)this.display.getComponent()).setMaximumSize(new Dimension(1000, 500));
                    this.iFrame.getContentPane().setLayout(new BorderLayout());
                    this.iFrame.getContentPane().add((Component)this.pane, "Center");
                    this.iFrame.getContentPane().add((Component)this.timeWidget, "North");
                    this.ControlPane.setLayout(new GridLayout(2, 1));
                    this.ControlPane.add((Component)this.heightWidget);
                    this.ControlPane.add((Component)this.control_widg);
                    this.iFrame.getContentPane().add((Component)this.ControlPane, "South");
                    this.iFrame.setSize(740, 450);
                }
            }
            catch (VisADException ex) {
                log.error(ex.toString());
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "VisADException while attempting to initialise VisAd. Message is : " + ex.getMessage());
                }
            }
            catch (RemoteException ex) {
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "Remote exception while attempting to initialise VisAd. Message is : " + ex.getMessage());
                }
            }
            catch (Exception ex) {
                log.error(ex.toString());
                if (this.getMonitor() == null) break block8;
                new NetErrorManager(this.getMonitor(), "Exception while attempting to initialise VisAd. Message is : " + ex.getMessage());
            }
        }
    }

    private void PlotVisAd() {
        Enumeration myEnum = this.ChartBuffers.elements();
        while (myEnum.hasMoreElements()) {
            try {
                SharedBuffer buffer = (SharedBuffer)myEnum.nextElement();
                ChartingHandle handle = buffer.getHandle();
                double[][] arr = buffer.get();
                int max = (int)this.timeMap.getRange()[1];
                if (max > arr.length) {
                    max = arr.length;
                }
                if (max > 0) {
                    double[][] copy = new double[1][(int)this.timeMap.getRange()[1]];
                    for (int i = 0; i < max; ++i) {
                        copy[0][i] = arr[i][0];
                    }
                    ((FlatField)this.flat_fields.get(handle)).setSamples(copy);
                    ((DataReferenceImpl)this.DataRefs.get(handle)).setData((Data)((FlatField)this.flat_fields.get(handle)));
                    this.display.addReference((DataReference)((DataReferenceImpl)this.DataRefs.get(handle)), (ConstantMap[])this.DataColors.get(handle));
                    continue;
                }
                log.error("No data to plot!");
                if (this.getMonitor() == null) continue;
                new NetErrorManager(this.getMonitor(), "Warning while attempting to plot VisAd chart. No data to plot!");
            }
            catch (VisADException ex) {
                log.error(ex.toString());
                if (this.getMonitor() == null) continue;
                new NetErrorManager(this.getMonitor(), "VisADException while attempting to plot VisAd chart. Message is : " + ex.getMessage());
            }
            catch (RemoteException ex) {
                if (this.getMonitor() == null) continue;
                new NetErrorManager(this.getMonitor(), "Remote Exception while attempting to plot VisAd chart. Message is : " + ex.getMessage());
            }
            catch (Exception ex) {
                log.error(ex.toString());
                if (this.getMonitor() == null) continue;
                new NetErrorManager(this.getMonitor(), "Exception while attempting to plot VisAd chart. Message is : " + ex.getMessage());
            }
        }
    }

    public VisADOutputSynapse() {
        this.initComponents();
        this.def_handle.setSerie(this.getSerie());
        this.def_handle.setBlueColor(230);
        this.def_handle.setGreenColor(0);
        this.def_handle.setRedColor(0);
        this.def_handle.setName("Serie " + this.getSerie());
    }

    private void initComponents() {
        this.iFrame = new JFrame();
        this.iFrame.setTitle(this.getTitle());
        this.iFrame.setResizable(this.isResizable());
        this.iFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                VisADOutputSynapse.this.exitForm(evt);
            }
        });
        this.iFrame.pack();
        this.ChartBuffers = new Hashtable();
        this.DataRefs = new Hashtable();
        this.DataColors = new Hashtable();
        this.flat_fields = new Hashtable();
        this.ControlPane = new JPanel();
        this.def_handle = new ChartingHandle();
        this.status_label = new JLabel("Waiting for network to run!");
        this.initVisAd(this.getMaxXaxis(), "Waiting...");
        this.visadinit = true;
    }

    private void exitForm(WindowEvent evt) {
        this.setShow(false);
    }

    @Override
    public void setMonitor(Monitor newMonitor) {
        this.monitor = newMonitor;
        if (this.monitor != null) {
            this.monitor.addNeuralNetListener(this);
        }
    }

    @Override
    public void fwdPut(Pattern pattern, ChartingHandle handle) {
        SharedBuffer sb = null;
        if (this.isEnabled() && pattern.getCount() > -1) {
            block8: {
                sb = this.ChartBuffers.size() > 0 ? (SharedBuffer)this.ChartBuffers.get(handle) : null;
                if (sb == null) {
                    try {
                        sb = new SharedBuffer();
                        sb.setHandle(handle);
                        this.ChartBuffers.put(handle, sb);
                        this.time_set = new Integer1DSet((MathType)this.time, (int)this.timeMap.getRange()[1]);
                        this.flat_fields.put(handle, new FlatField(this.func_time_height, this.time_set));
                        ConstantMap[] lineCMap = new ConstantMap[]{new ConstantMap((double)((float)handle.getRedColor() / 255.0f), Display.Red), new ConstantMap((double)((float)handle.getGreenColor() / 255.0f), Display.Green), new ConstantMap((double)((float)handle.getBlueColor() / 255.0f), Display.Blue), new ConstantMap(1.0, Display.LineWidth)};
                        this.DataColors.put(handle, lineCMap);
                        this.DataRefs.put(handle, new DataReferenceImpl(handle.getName()));
                    }
                    catch (VisADException ex) {
                        log.error(ex.toString());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "VisADException while attempting to define VisAd compononent in fwdPut(handle,pattern) method. Message is : " + ex.getMessage());
                        }
                    }
                    catch (Exception ex) {
                        log.error(ex.toString());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "Exception while attempting to define VisAd component in fwdPut(handle,pattern) method. Message is : " + ex.getMessage());
                        }
                    }
                    catch (OutOfMemoryError err) {
                        log.error(err.toString());
                        if (this.getMonitor() == null) break block8;
                        new NetErrorManager(this.getMonitor(), "Out of memory error while attempting to define VisAd component in fwdPut(handle,pattern) method. Message is : " + err.getMessage());
                    }
                }
            }
            sb.put(pattern.getArray()[handle.getSerie() - 1], pattern.getCount());
        }
    }

    @Override
    public void fwdPut(Pattern pattern) {
        if (this.isEnabled() && pattern.getCount() > -1) {
            SharedBuffer sb;
            block8: {
                sb = (SharedBuffer)this.ChartBuffers.get(this.def_handle);
                if (sb == null) {
                    try {
                        sb = new SharedBuffer();
                        sb.setHandle(this.def_handle);
                        this.ChartBuffers.put(this.def_handle, sb);
                        this.time_set = new Integer1DSet((MathType)this.time, (int)this.timeMap.getRange()[1]);
                        this.flat_fields.put(this.def_handle, new FlatField(this.func_time_height, this.time_set));
                        ConstantMap[] lineCMap = new ConstantMap[]{new ConstantMap((double)((float)this.def_handle.getRedColor() / 255.0f), Display.Red), new ConstantMap((double)((float)this.def_handle.getGreenColor() / 255.0f), Display.Green), new ConstantMap((double)((float)this.def_handle.getBlueColor() / 255.0f), Display.Blue), new ConstantMap(1.0, Display.LineWidth)};
                        this.DataColors.put(this.def_handle, lineCMap);
                        this.DataRefs.put(this.def_handle, new DataReferenceImpl(this.def_handle.getName()));
                    }
                    catch (VisADException ex) {
                        log.error(ex.toString());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "VisADException while attempting to define VisAd compononent in fwdPut(pattern) method. Message is : " + ex.getMessage());
                        }
                    }
                    catch (Exception ex) {
                        log.error(ex.toString());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "Exception while attempting to define VisAd component in fwdPut(pattern) method. Message is : " + ex.getMessage());
                        }
                    }
                    catch (OutOfMemoryError err) {
                        log.error(err.toString());
                        if (this.getMonitor() == null) break block8;
                        new NetErrorManager(this.getMonitor(), "Out of memory error while attempting to define VisAd component in fwdPut(pattern) method. Message is : " + err.getMessage());
                    }
                }
            }
            sb.put(pattern.getArray()[this.getSerie() - 1], pattern.getCount());
        }
    }

    @Override
    public Pattern revGet() {
        return null;
    }

    @Override
    public void setInputDimension(int newInputDimension) {
    }

    @Override
    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public int getInputDimension() {
        return 0;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
        if (show) {
            this.iFrame.setVisible(true);
        } else {
            this.iFrame.setVisible(false);
        }
    }

    @Override
    public double getMaxYaxis() {
        return this.maxYaxis;
    }

    @Override
    public void setMaxYaxis(double maxYaxis) {
        this.maxYaxis = maxYaxis;
    }

    @Override
    public int getMaxXaxis() {
        return this.maxXaxis;
    }

    @Override
    public void setMaxXaxis(int maxXaxis) {
        this.maxXaxis = maxXaxis;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initComponents();
        this.def_handle.setSerie(this.getSerie());
        this.def_handle.setBlueColor(230);
        this.def_handle.setGreenColor(0);
        this.def_handle.setRedColor(0);
        this.def_handle.setName("Serie " + this.getSerie());
        this.setShow(false);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.timeMap != null) {
            this.maxXaxis = (int)this.timeMap.getRange()[1];
        }
        if (this.heightMap != null) {
            this.maxYaxis = this.heightMap.getRange()[1];
        }
        out.defaultWriteObject();
    }

    public int getSerie() {
        if (this.serie < 1) {
            this.serie = 1;
        }
        return this.serie;
    }

    public void setSerie(int newSerie) {
        this.serie = newSerie < 1 ? 1 : newSerie;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.iFrame != null) {
            this.iFrame.setTitle(title);
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        if (this.iFrame != null) {
            this.iFrame.setResizable(resizable);
        }
    }

    @Override
    public TreeSet check() {
        TreeSet checks = new TreeSet();
        return checks;
    }

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
        block6: {
            this.ChartBuffers.clear();
            this.DataRefs.clear();
            this.DataColors.clear();
            this.flat_fields.clear();
            if (!this.visadinit) {
                this.initVisAd(this.getMaxXaxis(), "Collecting data ....");
                this.visadinit = true;
            } else {
                try {
                    this.display.removeAllReferences();
                }
                catch (VisADException ve) {
                    log.error(ve.toString());
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "VisADException while attempting to remove Display references in netStarted event. Message is : " + ve.getMessage());
                    }
                }
                catch (RemoteException re) {
                    log.error(re.toString());
                    if (this.getMonitor() == null) break block6;
                    new NetErrorManager(this.getMonitor(), "RemoteException while attempting to remove Display references in netStarted event. Message is : " + re.getMessage());
                }
            }
        }
        this.status_label.setText("Collecting data ....");
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
        try {
            this.status_label.setText("Data collected and displayed.");
            this.PlotVisAd();
        }
        catch (Exception ex) {
            log.error(ex.toString());
        }
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
    }

    @Override
    public void removeHandle(ChartingHandle handle) {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isOutputFull() {
        return this.outputFull;
    }

    @Override
    public void setOutputFull(boolean newoutputFull) {
        this.outputFull = newoutputFull;
    }

    @Override
    public void init() {
    }
}

