/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.util.Iconkit;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import org.joone.edit.JoonEdit;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;

public class AboutFrame
extends JDialog {
    private static final ILogger log = LoggerFactory.getLogger(AboutFrame.class);
    private static final String[] ABOUT_TEXT = new String[]{"Joone - Java Object Oriented Neural Engine", "http://www.joone.org", "pmarrone@users.sourceforge.net"};
    private static final String[] HALL_OF_FAME = new String[]{"Joone was developed by Paolo Marrone,", "with the valuable collaboration of:", "   Gavin Alford, Mark Allen, Jan Boonen, Yan Cheng Cheok,", "   Ka-Hing Cheung, Andrea Corti, Huascar Fiorletta, Firestrand,", "   Pascal Deschenes, Jan Erik Garshol, Harry Glasgow,", "   Jack Hawkins, Nathan Hindley, Olivier Hussenet,", "   Boris Jansen, Shen Linlin, Casey Marshall, Julien Norman,", "   Christian Ribeaud, Anat Rozenzon, Trevis Silvers,", "   Paul Sinclair, Thomas Lionel Smets, Jerry R.Vos"};
    private static final String[] EXTERNAL_PACK = new String[]{"Joone uses the following external packages:", "   JHotDraw - http://sourceforge.net/projects/jhotdraw", "   BeanShell - http://www.beanshell.org", "   Groovy - http://groovy.codehaus.org", "   jEdit-Syntax - http://sourceforge.net/projects/jedit-syntax", "   Log4j -  http://jakarta.apache.org/log4j", "   HSSF-POI - http://jakarta.apache.org/poi", "   L2FProd - http://common.l2fprod.com", "   NachoCalendar - http://nachocalendar.sourceforge.net", "   XStream - http://xstream.codehaus.org", "   VisAD - http://www.ssec.wisc.edu/~billh/visad.html"};

    AboutFrame(Frame owner) {
        this.setModal(true);
        JRootPane rp = new JRootPane();
        this.setRootPane(rp);
        rp.setLayout(new BorderLayout());
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        final Image img = kit.loadImageResource("/org/joone/images/jooneShadowSmall.gif");
        if (img != null) {
            Panel q = new Panel(){

                @Override
                public void paint(Graphics g) {
                    g.drawImage(img, 0, 0, this);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(84, 87);
                }
            };
            rp.add((Component)q, "West");
        }
        Button b = new Button("   OK   ");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutFrame.this.dispose();
            }
        });
        Panel p = new Panel();
        p.add(b);
        rp.add((Component)p, "South");
        TextBlock tb = new TextBlock(ABOUT_TEXT, HALL_OF_FAME, EXTERNAL_PACK);
        rp.add((Component)tb, "Center");
        this.setTitle("About Joone");
        this.setBackground(Color.white);
        this.setResizable(false);
        this.pack();
    }

    public void place(int x, int y) {
        this.setLocation(x - this.getWidth() / 2, y - this.getHeight() / 2);
    }

    class TextBlock
    extends Canvas {
        private static final int TEXT_PADDING = 5;
        private String[] lines;

        public TextBlock(String[] linesArg, String[] hallOfFameArg, String[] extPack) {
            int i;
            String neuralNetVersion = "unknown";
            Integer neuralNetNumericVersion = null;
            try {
                NeuralNet o = new NeuralNet();
                Method m = o.getClass().getMethod("getVersion", new Class[0]);
                if (m != null) {
                    neuralNetVersion = (String)m.invoke((Object)o, new Object[0]);
                }
                if ((m = o.getClass().getMethod("getNumericVersion", new Class[0])) != null) {
                    neuralNetNumericVersion = (Integer)m.invoke((Object)o, new Object[0]);
                }
            }
            catch (IllegalAccessException iae) {
                log.warn("IllegalAccessException getting NeuralNetwork version. Message is " + iae.getMessage(), iae);
            }
            catch (InvocationTargetException ite) {
                log.warn("InvocationTargetException getting NeuralNetwork version. Message is : " + ite.getMessage(), ite);
            }
            catch (NoSuchMethodException nsme) {
                log.warn("NoSuchMethodException getting NeuralNetwork version. Do not panic. Message is : " + nsme.getMessage(), nsme);
            }
            ArrayList<String> col = new ArrayList<String>();
            for (i = 0; i < linesArg.length; ++i) {
                col.add(linesArg[i]);
            }
            col.add("");
            col.add("Editor version: " + JoonEdit.getVersion());
            col.add("Engine version: " + neuralNetVersion);
            if (neuralNetNumericVersion == null || neuralNetNumericVersion < JoonEdit.getNumericRecommendedEngineVersion()) {
                col.add("Engine version " + JoonEdit.getRecommendedEngineVersion() + " or above recommended");
            }
            col.add("");
            for (i = 0; i < hallOfFameArg.length; ++i) {
                col.add(hallOfFameArg[i]);
            }
            col.add("");
            for (i = 0; i < extPack.length; ++i) {
                col.add(extPack[i]);
            }
            this.lines = new String[col.size()];
            Iterator iter = col.iterator();
            int i2 = 0;
            while (iter.hasNext()) {
                this.lines[i2++] = (String)iter.next();
            }
        }

        @Override
        public void paint(Graphics g) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int lineAscent = fm.getAscent();
            int lineHeight = fm.getHeight();
            for (int i = 0; i < this.lines.length; ++i) {
                g.drawString(this.lines[i], 5, i * lineHeight + lineAscent + 5);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int lineHeight = fm.getHeight();
            int width = 0;
            for (int i = 0; i < this.lines.length; ++i) {
                if (fm.stringWidth(this.lines[i]) <= width) continue;
                width = fm.stringWidth(this.lines[i]);
            }
            return new Dimension(width + 10, this.lines.length * lineHeight + 10);
        }
    }
}

