/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.PaletteListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;

public abstract class PaletteButton
extends JButton
implements MouseListener,
MouseMotionListener {
    static final int NORMAL = 1;
    static final int PRESSED = 2;
    static final int SELECTED = 3;
    private PaletteListener fListener;
    private int fState;
    private int fOldState;

    public PaletteButton(PaletteListener listener) {
        this.fListener = listener;
        this.fOldState = 1;
        this.fState = 1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Object value() {
        return null;
    }

    public String name() {
        return "";
    }

    public void reset() {
        this.fState = 1;
        this.setSelected(false);
        this.repaint();
    }

    public void select() {
        this.fState = 3;
        this.setSelected(true);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.fOldState = this.fState;
        this.fState = 2;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.fState = this.contains(e.getX(), e.getY()) ? 2 : this.fOldState;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.fState = this.fOldState;
        this.repaint();
        if (this.contains(e.getX(), e.getY())) {
            this.fListener.paletteUserSelected(this);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.fListener.paletteUserOver(this, true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.fState == 2) {
            this.mouseDragged(e);
        }
        this.fListener.paletteUserOver(this, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

