/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteIcon;
import CH.ifa.draw.util.PaletteListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.ImageIcon;

public class ToolButton
extends PaletteButton {
    private String fName;
    private Tool fTool;
    private PaletteIcon fIcon;

    public ToolButton(PaletteListener listener, String iconName, String name, Tool tool) {
        super(listener);
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        Image[] im = new Image[]{kit.loadImageResource(iconName + "1.gif"), kit.loadImageResource(iconName + "2.gif"), kit.loadImageResource(iconName + "3.gif")};
        MediaTracker tracker = new MediaTracker(this);
        for (int i = 0; i < 3; ++i) {
            tracker.addImage(im[i], i);
        }
        try {
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fIcon = new PaletteIcon(new Dimension(24, 24), im[0], im[1], im[2]);
        this.fTool = tool;
        this.fName = name;
        this.setIcon(new ImageIcon(im[0]));
        this.setPressedIcon(new ImageIcon(im[1]));
        this.setSelectedIcon(new ImageIcon(im[2]));
        this.setToolTipText(name);
    }

    public Tool tool() {
        return this.fTool;
    }

    @Override
    public String name() {
        return this.fName;
    }

    public Object attributeValue() {
        return this.tool();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.fIcon.getWidth(), this.fIcon.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.fIcon.getWidth(), this.fIcon.getHeight());
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.fIcon.getWidth(), this.fIcon.getHeight());
    }

    public void paintSelected(Graphics g) {
        if (this.fIcon.selected() != null) {
            g.drawImage(this.fIcon.selected(), 0, 0, this);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.isSelected()) {
            this.paintSelected(g);
        } else {
            super.paint(g);
        }
    }
}

