/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractConnector;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class LocatorConnector
extends AbstractConnector {
    public static final int SIZE = 8;
    private Locator fLocator;
    private static final long serialVersionUID = 5062833203337604181L;
    private int locatorConnectorSerializedDataVersion = 1;

    public LocatorConnector() {
        this.fLocator = null;
    }

    public LocatorConnector(Figure owner, Locator l) {
        super(owner);
        this.fLocator = l;
    }

    protected Point locate(ConnectionFigure connection) {
        return this.fLocator.locate(this.owner());
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return this.displayBox().contains(x, y);
    }

    @Override
    public Rectangle displayBox() {
        Point p = this.fLocator.locate(this.owner());
        return new Rectangle(p.x - 4, p.y - 4, 8, 8);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.blue);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fLocator);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fLocator = (Locator)dr.readStorable();
    }
}

