/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.samples.pert;

import CH.ifa.draw.figures.NumberTextFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.samples.pert.PertDependency;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.ConnectionHandle;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class PertFigure
extends CompositeFigure {
    private static final int BORDER = 3;
    private Rectangle fDisplayBox;
    private Vector fPreTasks;
    private Vector fPostTasks;
    private static final long serialVersionUID = -7877776240236946511L;
    private int pertFigureSerializedDataVersion = 1;

    public PertFigure() {
        this.initialize();
    }

    public int start() {
        int start = 0;
        Enumeration i = this.fPreTasks.elements();
        while (i.hasMoreElements()) {
            PertFigure f = (PertFigure)i.nextElement();
            start = Math.max(start, f.end());
        }
        return start;
    }

    public int end() {
        return this.asInt(2);
    }

    public int duration() {
        return this.asInt(1);
    }

    public void setEnd(int value) {
        this.setInt(2, value);
    }

    public void addPreTask(PertFigure figure) {
        if (!this.fPreTasks.contains(figure)) {
            this.fPreTasks.addElement(figure);
        }
    }

    public void addPostTask(PertFigure figure) {
        if (!this.fPostTasks.contains(figure)) {
            this.fPostTasks.addElement(figure);
        }
    }

    public void removePreTask(PertFigure figure) {
        this.fPreTasks.removeElement(figure);
    }

    public void removePostTask(PertFigure figure) {
        this.fPostTasks.removeElement(figure);
    }

    private int asInt(int figureIndex) {
        NumberTextFigure t = (NumberTextFigure)this.figureAt(figureIndex);
        return t.getValue();
    }

    private String taskName() {
        TextFigure t = (TextFigure)this.figureAt(0);
        return t.getText();
    }

    private void setInt(int figureIndex, int value) {
        NumberTextFigure t = (NumberTextFigure)this.figureAt(figureIndex);
        t.setValue(value);
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
        super.basicMoveBy(x, y);
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
        this.layout();
    }

    private void drawBorder(Graphics g) {
        super.draw(g);
        Rectangle r = this.displayBox();
        Figure f = this.figureAt(0);
        Rectangle rf = f.displayBox();
        g.setColor(Color.gray);
        g.drawLine(r.x, r.y + rf.height + 2, r.x + r.width, r.y + rf.height + 2);
        g.setColor(Color.white);
        g.drawLine(r.x, r.y + rf.height + 3, r.x + r.width, r.y + rf.height + 3);
        g.setColor(Color.white);
        g.drawLine(r.x, r.y, r.x, r.y + r.height);
        g.drawLine(r.x, r.y, r.x + r.width, r.y);
        g.setColor(Color.gray);
        g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
    }

    @Override
    public void draw(Graphics g) {
        this.drawBorder(g);
        super.draw(g);
    }

    @Override
    public Vector handles() {
        Vector<LocatorHandle> handles = new Vector<LocatorHandle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        handles.addElement(new ConnectionHandle(this, RelativeLocator.east(), new PertDependency()));
        return handles;
    }

    private void initialize() {
        this.fPostTasks = new Vector();
        this.fPreTasks = new Vector();
        this.fDisplayBox = new Rectangle(0, 0, 0, 0);
        Font f = new Font("Helvetica", 0, 12);
        Font fb = new Font("Helvetica", 1, 12);
        TextFigure name = new TextFigure();
        name.setFont(fb);
        name.setText("Task");
        this.add(name);
        NumberTextFigure duration = new NumberTextFigure();
        duration.setValue(0);
        duration.setFont(fb);
        this.add(duration);
        NumberTextFigure end2 = new NumberTextFigure();
        end2.setValue(0);
        end2.setFont(f);
        end2.setReadOnly(true);
        this.add(end2);
    }

    private void layout() {
        Point partOrigin = new Point(this.fDisplayBox.x, this.fDisplayBox.y);
        partOrigin.translate(3, 3);
        Dimension extent = new Dimension(0, 0);
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Dimension partExtent = f.size();
            Point corner = new Point(partOrigin.x + partExtent.width, partOrigin.y + partExtent.height);
            f.basicDisplayBox(partOrigin, corner);
            extent.width = Math.max(extent.width, partExtent.width);
            extent.height += partExtent.height;
            partOrigin.y += partExtent.height;
        }
        this.fDisplayBox.width = extent.width + 6;
        this.fDisplayBox.height = extent.height + 6;
    }

    private boolean needsLayout() {
        Dimension extent = new Dimension(0, 0);
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            extent.width = Math.max(extent.width, f.size().width);
        }
        int newExtent = extent.width + 6;
        return newExtent != this.fDisplayBox.width;
    }

    public void update(FigureChangeEvent e) {
        if (e.getFigure() == this.figureAt(1)) {
            this.updateDurations();
        }
        if (this.needsLayout()) {
            this.layout();
            this.changed();
        }
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
        this.update(e);
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
        this.update(e);
    }

    public void notifyPostTasks() {
        Enumeration i = this.fPostTasks.elements();
        while (i.hasMoreElements()) {
            ((PertFigure)i.nextElement()).updateDurations();
        }
    }

    public void updateDurations() {
        int newEnd = this.start() + this.duration();
        if (newEnd != this.end()) {
            this.setEnd(newEnd);
            this.notifyPostTasks();
        }
    }

    public boolean hasCycle(Figure start) {
        if (start == this) {
            return true;
        }
        Enumeration i = this.fPreTasks.elements();
        while (i.hasMoreElements()) {
            if (!((PertFigure)i.nextElement()).hasCycle(start)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        this.writeTasks(dw, this.fPreTasks);
        this.writeTasks(dw, this.fPostTasks);
    }

    public void writeTasks(StorableOutput dw, Vector v) {
        dw.writeInt(v.size());
        Enumeration i = v.elements();
        while (i.hasMoreElements()) {
            dw.writeStorable((Storable)i.nextElement());
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.layout();
        this.fPreTasks = this.readTasks(dr);
        this.fPostTasks = this.readTasks(dr);
    }

    @Override
    public Insets connectionInsets() {
        Rectangle r = this.fDisplayBox;
        int cx = r.width / 2;
        int cy = r.height / 2;
        return new Insets(cy, cx, cy, cx);
    }

    public Vector readTasks(StorableInput dr) throws IOException {
        int size = dr.readInt();
        Vector<Figure> v = new Vector<Figure>(size);
        for (int i = 0; i < size; ++i) {
            v.addElement((Figure)dr.readStorable());
        }
        return v;
    }
}

