/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.samples.javadraw;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.DecoratorFigure;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class AnimationDecorator
extends DecoratorFigure {
    private int fXVelocity;
    private int fYVelocity;
    private static final long serialVersionUID = 7894632974364110685L;
    private int animationDecoratorSerializedDataVersion = 1;

    public AnimationDecorator() {
    }

    public AnimationDecorator(Figure figure) {
        super(figure);
        this.fXVelocity = 4;
        this.fYVelocity = 4;
    }

    public void velocity(int xVelocity, int yVelocity) {
        this.fXVelocity = xVelocity;
        this.fYVelocity = yVelocity;
    }

    public Point velocity() {
        return new Point(this.fXVelocity, this.fYVelocity);
    }

    public void animationStep() {
        int xSpeed = this.fXVelocity;
        int ySpeed = this.fYVelocity;
        Rectangle box = this.displayBox();
        if (box.x + box.width > 300 && xSpeed > 0) {
            xSpeed = -xSpeed;
        }
        if (box.y + box.height > 300 && ySpeed > 0) {
            ySpeed = -ySpeed;
        }
        if (box.x < 0 && xSpeed < 0) {
            xSpeed = -xSpeed;
        }
        if (box.y < 0 && ySpeed < 0) {
            ySpeed = -ySpeed;
        }
        this.velocity(xSpeed, ySpeed);
        this.moveBy(xSpeed, ySpeed);
    }

    @Override
    public synchronized void basicMoveBy(int x, int y) {
        super.basicMoveBy(x, y);
    }

    @Override
    public synchronized void basicDisplayBox(Point origin, Point corner) {
        super.basicDisplayBox(origin, corner);
    }

    @Override
    public synchronized Rectangle displayBox() {
        return super.displayBox();
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fXVelocity);
        dw.writeInt(this.fYVelocity);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fXVelocity = dr.readInt();
        this.fYVelocity = dr.readInt();
    }
}

