/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.event.MouseEvent;

public class ScribbleTool
extends AbstractTool {
    private PolyLineFigure fScribble;
    private int fLastX;
    private int fLastY;

    public ScribbleTool(DrawingView view) {
        super(view);
    }

    @Override
    public void activate() {
        super.activate();
        this.fScribble = null;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.fScribble != null && (this.fScribble.size().width < 4 || this.fScribble.size().height < 4)) {
            this.drawing().remove(this.fScribble);
        }
    }

    private void point(int x, int y) {
        if (this.fScribble == null) {
            this.fScribble = new PolyLineFigure(x, y);
            this.view().add(this.fScribble);
        } else if (this.fLastX != x || this.fLastY != y) {
            this.fScribble.addPoint(x, y);
        }
        this.fLastX = x;
        this.fLastY = y;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        if (e.getClickCount() >= 2) {
            this.fScribble = null;
            this.editor().toolDone();
        } else {
            this.point(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.fScribble != null) {
            this.point(e.getX(), e.getY());
        }
    }
}

