/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class LineConnection
extends PolyLineFigure
implements ConnectionFigure {
    protected Connector fStart = null;
    protected Connector fEnd = null;
    private static final long serialVersionUID = 6883731614578414801L;
    private int lineConnectionSerializedDataVersion = 1;

    public LineConnection() {
        super(4);
        this.setStartDecoration(new ArrowTip());
        this.setEndDecoration(new ArrowTip());
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    protected void basicMoveBy(int dx, int dy) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            ((Point)this.fPoints.elementAt(i)).translate(dx, dy);
        }
        this.updateConnection();
    }

    @Override
    public void connectStart(Connector start) {
        this.fStart = start;
        this.startFigure().addFigureChangeListener(this);
    }

    @Override
    public void connectEnd(Connector end2) {
        this.fEnd = end2;
        this.endFigure().addFigureChangeListener(this);
        this.handleConnect(this.startFigure(), this.endFigure());
    }

    @Override
    public void disconnectStart() {
        this.startFigure().removeFigureChangeListener(this);
        this.fStart = null;
    }

    @Override
    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.endFigure().removeFigureChangeListener(this);
        this.fEnd = null;
    }

    @Override
    public boolean connectsSame(ConnectionFigure other) {
        return other.start() == this.start() && other.end() == this.end();
    }

    protected void handleDisconnect(Figure start, Figure end2) {
    }

    protected void handleConnect(Figure start, Figure end2) {
    }

    public Figure startFigure() {
        if (this.start() != null) {
            return this.start().owner();
        }
        return null;
    }

    public Figure endFigure() {
        if (this.end() != null) {
            return this.end().owner();
        }
        return null;
    }

    @Override
    public Connector start() {
        return this.fStart;
    }

    @Override
    public Connector end() {
        return this.fEnd;
    }

    @Override
    public boolean canConnect(Figure start, Figure end2) {
        return true;
    }

    @Override
    public void startPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() == 0) {
            this.fPoints.addElement(new Point(x, y));
        } else {
            this.fPoints.setElementAt(new Point(x, y), 0);
        }
        this.changed();
    }

    @Override
    public void endPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() < 2) {
            this.fPoints.addElement(new Point(x, y));
        } else {
            this.fPoints.setElementAt(new Point(x, y), this.fPoints.size() - 1);
        }
        this.changed();
    }

    @Override
    public Point startPoint() {
        Point p = (Point)this.fPoints.firstElement();
        return new Point(p.x, p.y);
    }

    @Override
    public Point endPoint() {
        Point p = (Point)this.fPoints.lastElement();
        return new Point(p.x, p.y);
    }

    @Override
    public Vector handles() {
        Vector<AbstractHandle> handles = new Vector<AbstractHandle>(this.fPoints.size());
        handles.addElement(new ChangeConnectionStartHandle(this));
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new PolyLineHandle(this, LineConnection.locator(i), i));
        }
        handles.addElement(new ChangeConnectionEndHandle(this));
        return handles;
    }

    @Override
    public void setPointAt(Point p, int i) {
        super.setPointAt(p, i);
        this.layoutConnection();
    }

    @Override
    public void insertPointAt(Point p, int i) {
        super.insertPointAt(p, i);
        this.layoutConnection();
    }

    @Override
    public void removePointAt(int i) {
        super.removePointAt(i);
        this.layoutConnection();
    }

    @Override
    public void updateConnection() {
        if (this.fStart != null) {
            Point start = this.fStart.findStart(this);
            this.startPoint(start.x, start.y);
        }
        if (this.fEnd != null) {
            Point end2 = this.fEnd.findEnd(this);
            this.endPoint(end2.x, end2.y);
        }
    }

    public void layoutConnection() {
        this.updateConnection();
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
        this.updateConnection();
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    @Override
    public void release() {
        super.release();
        this.handleDisconnect(this.startFigure(), this.endFigure());
        if (this.fStart != null) {
            this.startFigure().removeFigureChangeListener(this);
        }
        if (this.fEnd != null) {
            this.endFigure().removeFigureChangeListener(this);
        }
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fStart);
        dw.writeStorable(this.fEnd);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        Connector end2;
        super.read(dr);
        Connector start = (Connector)dr.readStorable();
        if (start != null) {
            this.connectStart(start);
        }
        if ((end2 = (Connector)dr.readStorable()) != null) {
            this.connectEnd(end2);
        }
        if (start != null && end2 != null) {
            this.updateConnection();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.fStart != null) {
            this.connectStart(this.fStart);
        }
        if (this.fEnd != null) {
            this.connectEnd(this.fEnd);
        }
    }
}

