/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.FigureAttributes;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.IOException;

public abstract class AbstractLineDecoration
implements LineDecoration {
    static final long serialVersionUID = 1577970039258356627L;
    private Color fFillColor;
    private Color fBorderColor;

    @Override
    public void draw(Graphics g, int x1, int y1, int x2, int y2) {
        Color drawColor;
        Polygon p = this.outline(x1, y1, x2, y2);
        if (this.getFillColor() == null) {
            g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
        } else {
            drawColor = g.getColor();
            g.setColor(this.getFillColor());
            g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
            g.setColor(drawColor);
        }
        if (this.getBorderColor() != this.getFillColor()) {
            drawColor = g.getColor();
            g.setColor(this.getBorderColor());
            g.drawPolygon(p.xpoints, p.ypoints, p.npoints);
            g.setColor(drawColor);
        }
    }

    public abstract Polygon outline(int var1, int var2, int var3, int var4);

    @Override
    public void write(StorableOutput dw) {
        if (this.getFillColor() != null) {
            FigureAttributes.writeColor(dw, "FillColor", this.getFillColor());
        } else {
            dw.writeString("noFillColor");
        }
        if (this.getBorderColor() != null) {
            FigureAttributes.writeColor(dw, "BorderColor", this.getBorderColor());
        } else {
            dw.writeString("noBorderColor");
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        String borderColorId;
        String fillColorId = dr.readString();
        if (fillColorId.equals("FillColor")) {
            this.setFillColor(FigureAttributes.readColor(dr));
        }
        if ((borderColorId = dr.readString()).equals("BorderColor")) {
            this.setBorderColor(FigureAttributes.readColor(dr));
        }
    }

    public void setFillColor(Color fillColor) {
        this.fFillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fFillColor;
    }

    public void setBorderColor(Color borderColor) {
        this.fBorderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.fBorderColor;
    }
}

