/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PolygonTool
extends AbstractTool {
    private PolygonFigure fPolygon;
    private int fLastX;
    private int fLastY;

    public PolygonTool(DrawingView view) {
        super(view);
    }

    @Override
    public void activate() {
        super.activate();
        this.fPolygon = null;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.fPolygon != null) {
            this.fPolygon.smoothPoints();
            if (this.fPolygon.pointCount() < 3 || this.fPolygon.size().width < 4 || this.fPolygon.size().height < 4) {
                this.drawing().remove(this.fPolygon);
            }
        }
        this.fPolygon = null;
    }

    private void addPoint(int x, int y) {
        if (this.fPolygon == null) {
            this.fPolygon = new PolygonFigure(x, y);
            this.view().add(this.fPolygon);
            this.fPolygon.addPoint(x, y);
        } else if (this.fLastX != x || this.fLastY != y) {
            this.fPolygon.addPoint(x, y);
        }
        this.fLastX = x;
        this.fLastY = y;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        x = e.getX();
        y = e.getY();
        if (e.getClickCount() >= 2) {
            if (this.fPolygon != null) {
                this.fPolygon.smoothPoints();
                this.editor().toolDone();
            }
            this.fPolygon = null;
        } else {
            this.addPoint(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseMove(MouseEvent e, int x, int y) {
        if (this.fPolygon != null && this.fPolygon.pointCount() > 1) {
            this.fPolygon.setPointAt(new Point(x, y), this.fPolygon.pointCount() - 1);
            this.view().checkDamage();
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        x = e.getX();
        y = e.getY();
        this.addPoint(x, y);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
    }
}

